/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.nullness.NullnessUtils;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnnotations;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import javax.inject.Inject;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="The type Void is not annotated @Nullable", severity=BugPattern.SeverityLevel.SUGGESTION)
public class VoidMissingNullable
extends BugChecker
implements BugChecker.ParameterizedTypeTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private final boolean beingConservative;

    @Inject
    public VoidMissingNullable(ErrorProneFlags flags) {
        this.beingConservative = NullnessUtils.nullnessChecksShouldBeConservative(flags);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Description matchParameterizedType(ParameterizedTypeTree parameterizedTypeTree, VisitorState state) {
        if (this.beingConservative && state.errorProneOptions().isTestOnlyTarget()) {
            return Description.NO_MATCH;
        }
        if (this.beingConservative && !VoidMissingNullable.isInNullMarkedScope(state)) {
            return Description.NO_MATCH;
        }
        for (Tree tree : parameterizedTypeTree.getTypeArguments()) {
            void var4_4;
            if (tree instanceof WildcardTree) {
                Tree tree2 = ((WildcardTree)tree).getBound();
            }
            this.checkTree((Tree)var4_4, state);
        }
        return Description.NO_MATCH;
    }

    private static boolean isInNullMarkedScope(VisitorState state) {
        for (Tree tree : state.getPath()) {
            if (!tree.getKind().asInterface().equals(ClassTree.class) && tree.getKind() != Tree.Kind.METHOD) continue;
            Symbol enclosingElement = ASTHelpers.getSymbol(tree);
            return NullnessUtils.isInNullMarkedScope(enclosingElement, state);
        }
        throw new AssertionError((Object)("parameterized type without enclosing element: " + Iterables.toString(state.getPath())));
    }

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (this.beingConservative && state.errorProneOptions().isTestOnlyTarget()) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol(tree);
        if (!this.typeMatches(sym.getReturnType(), sym, state)) {
            return Description.NO_MATCH;
        }
        if (this.beingConservative && !NullnessUtils.isInNullMarkedScope(sym, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)NullnessUtils.fixByAddingNullableAnnotationToReturnType(state, tree));
    }

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (this.beingConservative && state.errorProneOptions().isTestOnlyTarget()) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasNoExplicitType(tree, state)) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol sym = ASTHelpers.getSymbol(tree);
        if (sym.getKind() == ElementKind.LOCAL_VARIABLE) {
            return Description.NO_MATCH;
        }
        if (!this.typeMatches(sym.type, sym, state)) {
            return Description.NO_MATCH;
        }
        if (this.beingConservative && !NullnessUtils.isInNullMarkedScope(sym, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix fix = NullnessUtils.fixByAddingNullableAnnotationToType(state, tree);
        if (fix.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)fix);
    }

    private void checkTree(Tree tree, VisitorState state) {
        if (!this.typeMatches(ASTHelpers.getType(tree), state)) {
            return;
        }
        if (NullnessAnnotations.fromAnnotations(VoidMissingNullable.annotationsIfAnnotatedTypeTree(tree)).orElse(null) == Nullness.NULLABLE) {
            return;
        }
        SuggestedFix fix = NullnessUtils.fixByAnnotatingTypeUseOnlyLocationWithNullableAnnotation(state, tree);
        if (fix.isEmpty()) {
            return;
        }
        state.reportMatch(this.describeMatch(tree, (Fix)fix));
    }

    private boolean typeMatches(Type type, Symbol sym, VisitorState state) {
        return NullnessUtils.isVoid(type, state) && NullnessAnnotations.fromAnnotationsOn(sym).orElse(null) != Nullness.NULLABLE;
    }

    private boolean typeMatches(Type type, VisitorState state) {
        return NullnessUtils.isVoid(type, state) && NullnessAnnotations.fromAnnotationsOn(type).orElse(null) != Nullness.NULLABLE;
    }

    private static ImmutableList<String> annotationsIfAnnotatedTypeTree(Tree tree) {
        if (tree instanceof AnnotatedTypeTree) {
            AnnotatedTypeTree annotated = (AnnotatedTypeTree)tree;
            return annotated.getAnnotations().stream().map(ASTHelpers::getAnnotationName).collect(ImmutableList.toImmutableList());
        }
        return ImmutableList.of();
    }
}

