/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.nullness.NullnessUtils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import javax.inject.Inject;

@BugPattern(summary="Method overrides Object.equals but does not have @Nullable on its parameter", severity=BugPattern.SeverityLevel.SUGGESTION)
public class EqualsMissingNullable
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private final boolean beingConservative;

    @Inject
    public EqualsMissingNullable(ErrorProneFlags flags) {
        this.beingConservative = NullnessUtils.nullnessChecksShouldBeConservative(flags);
    }

    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        if (this.beingConservative && state.errorProneOptions().isTestOnlyTarget()) {
            return Description.NO_MATCH;
        }
        if (!Matchers.equalsMethodDeclaration().matches(methodTree, state)) {
            return Description.NO_MATCH;
        }
        VariableTree parameterTree = Iterables.getOnlyElement(methodTree.getParameters());
        Symbol.VarSymbol parameter = ASTHelpers.getSymbol(parameterTree);
        if (NullnessUtils.isAlreadyAnnotatedNullable(parameter)) {
            return Description.NO_MATCH;
        }
        if (this.beingConservative && !NullnessUtils.isInNullMarkedScope(parameter, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix fix = NullnessUtils.fixByAddingNullableAnnotationToType(state, parameterTree);
        if (fix.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(parameterTree, (Fix)fix);
    }
}

