/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.JavadocTag;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreePath;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@BugPattern(summary="This Javadoc tag is malformed. The correct syntax is {@tag and not @{tag.", severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false)
public final class MalformedInlineTag
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final Pattern MALFORMED_PATTERN = Pattern.compile("@\\{(" + JavadocTag.ALL_INLINE_TAGS.stream().map(JavadocTag::name).collect(Collectors.joining("|")) + ")");

    @Override
    public Description matchClass(ClassTree classTree, VisitorState state) {
        return this.handle(state);
    }

    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        return this.handle(state);
    }

    @Override
    public Description matchVariable(VariableTree variableTree, VisitorState state) {
        return this.handle(state);
    }

    private Description handle(VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path == null) {
            return Description.NO_MATCH;
        }
        Tokens.Comment comment = ((DCTree.DCDocComment)path.getDocComment()).comment;
        Matcher matcher = MALFORMED_PATTERN.matcher(comment.getText());
        while (matcher.find()) {
            String tag = matcher.group(1);
            int startPos = comment.getSourcePos(matcher.start());
            int endPos = comment.getSourcePos(matcher.end());
            state.reportMatch(this.buildDescription(Utils.getDiagnosticPosition(startPos, path.getTreePath().getLeaf())).setMessage(String.format("The correct syntax to open this inline tag is {@%s.", tag)).addFix(SuggestedFix.replace(startPos, endPos, "{@" + tag)).build());
        }
        return Description.NO_MATCH;
    }
}

