/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.JavadocTag;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@BugPattern(summary="This tag is invalid.", severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false)
public final class InvalidInlineTag
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final Pattern PARAM_MATCHER = Pattern.compile("\\{?@param ([a-zA-Z0-9]+)}?");
    private static final Pattern ANCHORED_PARAM_MATCHER = Pattern.compile("^\\{?@param ([a-zA-Z0-9]+)}?");
    private static final Splitter DOT_SPLITTER = Splitter.on('.');

    private void scanTags(VisitorState state, Context context, ImmutableSet<String> parameters, DocTreePath path) {
        new InvalidTagChecker(state, context, parameters).scan(path, null);
    }

    @Override
    public Description matchClass(ClassTree classTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            ImmutableSet<String> parameters = ImmutableSet.of();
            this.scanTags(state, Context.CLASS, parameters, path);
        }
        return Description.NO_MATCH;
    }

    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            ImmutableSet<String> parameters = methodTree.getParameters().stream().map(v -> v.getName().toString()).collect(ImmutableSet.toImmutableSet());
            this.scanTags(state, Context.METHOD, parameters, path);
        }
        return Description.NO_MATCH;
    }

    @Override
    public Description matchVariable(VariableTree variableTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            this.scanTags(state, Context.VARIABLE, ImmutableSet.of(), path);
        }
        return Description.NO_MATCH;
    }

    static String getMessageForInvalidTag(String paramName) {
        return String.format("@%1$s is not a valid tag, but is a parameter name. Use {@code %1$s} to refer to parameter names inline.", paramName);
    }

    final class InvalidTagChecker
    extends DocTreePathScanner<Void, Void> {
        private final VisitorState state;
        private final ImmutableSet<String> parameters;
        private final Context context;
        private final Set<DocTree> fixedTags = new HashSet<DocTree>();

        private InvalidTagChecker(VisitorState state, Context context, ImmutableSet<String> parameters) {
            this.state = state;
            this.context = context;
            this.parameters = parameters;
        }

        @Override
        public Void visitErroneous(ErroneousTree erroneousTree, Void unused) {
            String parameterName;
            Matcher matcher = ANCHORED_PARAM_MATCHER.matcher(erroneousTree.getBody());
            if (matcher.find() && this.parameters.contains(parameterName = matcher.group(1))) {
                String message = String.format("@param cannot be used inline to refer to parameters; {@code %s} is recommended", parameterName);
                this.state.reportMatch(InvalidInlineTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix(Utils.replace(erroneousTree, String.format("{@code %s}", parameterName), this.state)).build());
            }
            return null;
        }

        @Override
        public Void visitText(TextTree node, Void unused) {
            this.handleMalformedTags(node);
            this.handleIncorrectParens(node);
            this.handleDanglingParams(node);
            return (Void)super.visitText(node, null);
        }

        private void handleMalformedTags(TextTree node) {
            String body = node.getBody();
            Matcher matcher = this.context.misplacedCurly.matcher(body);
            Tokens.Comment comment = ((DCTree.DCDocComment)this.getCurrentPath().getDocComment()).comment;
            while (matcher.find()) {
                int beforeAt = comment.getSourcePos(((DCTree.DCText)node).pos + matcher.start());
                int startOfCurly = comment.getSourcePos(((DCTree.DCText)node).pos + matcher.end(1));
                SuggestedFix fix = SuggestedFix.builder().replace(beforeAt, beforeAt, "{").replace(startOfCurly, startOfCurly + 1, " ").build();
                this.state.reportMatch(InvalidInlineTag.this.describeMatch(Utils.getDiagnosticPosition(beforeAt, this.getCurrentPath().getTreePath().getLeaf()), (Fix)fix));
            }
        }

        private void handleIncorrectParens(TextTree node) {
            String body = node.getBody();
            Matcher matcher = this.context.parensRatherThanCurly.matcher(body);
            Tokens.Comment comment = ((DCTree.DCDocComment)this.getCurrentPath().getDocComment()).comment;
            while (matcher.find()) {
                int beforeAt = comment.getSourcePos(((DCTree.DCText)node).pos + matcher.start());
                SuggestedFix.Builder fix = SuggestedFix.builder().replace(beforeAt, beforeAt + 1, "{");
                Optional<Integer> found = this.findClosingBrace(body, matcher.start(1));
                found.ifPresent(pos -> {
                    int closing = comment.getSourcePos(((DCTree.DCText)node).pos + pos);
                    fix.replace(closing, closing + 1, "}");
                });
                this.state.reportMatch(InvalidInlineTag.this.buildDescription(Utils.getDiagnosticPosition(beforeAt, this.getCurrentPath().getTreePath().getLeaf())).setMessage(String.format("Curly braces should be used for inline Javadoc tags: {@%s ...}", matcher.group(1))).addFix(fix.build()).build());
            }
        }

        private Optional<Integer> findClosingBrace(String body, int startPos) {
            int parenDepth = 0;
            block5: for (int pos = startPos; pos < body.length(); ++pos) {
                char c = body.charAt(pos);
                switch (c) {
                    case '(': {
                        ++parenDepth;
                        continue block5;
                    }
                    case ')': {
                        if (parenDepth == 0) {
                            return Optional.of(pos);
                        }
                        --parenDepth;
                        continue block5;
                    }
                    case '}': {
                        return Optional.empty();
                    }
                }
            }
            return Optional.empty();
        }

        private void handleDanglingParams(TextTree node) {
            Matcher matcher = PARAM_MATCHER.matcher(node.getBody());
            Tokens.Comment comment = ((DCTree.DCDocComment)this.getCurrentPath().getDocComment()).comment;
            while (matcher.find()) {
                int startPos = comment.getSourcePos(((DCTree.DCText)node).pos + matcher.start());
                int endPos = comment.getSourcePos(((DCTree.DCText)node).pos + matcher.end());
                String paramName = matcher.group(1);
                SuggestedFix fix = SuggestedFix.replace(startPos, endPos, String.format("{@code %s}", paramName));
                this.state.reportMatch(InvalidInlineTag.this.describeMatch(Utils.getDiagnosticPosition(startPos, this.getCurrentPath().getTreePath().getLeaf()), (Fix)fix));
            }
        }

        @Override
        public Void visitUnknownInlineTag(UnknownInlineTagTree unknownInlineTagTree, Void unused) {
            int startPos;
            String name = unknownInlineTagTree.getTagName();
            if (name.equals("param")) {
                startPos = Utils.getStartPosition(unknownInlineTagTree, this.state);
                int endPos = Utils.getEndPosition(unknownInlineTagTree, this.state);
                CharSequence text = this.state.getSourceCode().subSequence(startPos, endPos);
                Matcher matcher = PARAM_MATCHER.matcher(text);
                if (matcher.find()) {
                    String parameterName = matcher.group(1);
                    if (this.parameters.contains(parameterName)) {
                        String message = String.format("@param cannot be used inline to refer to parameters; {@code %s} is recommended", parameterName);
                        this.state.reportMatch(InvalidInlineTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix(Utils.replace(unknownInlineTagTree, String.format("{@code %s}", parameterName), this.state)).build());
                    }
                    this.fixedTags.add(unknownInlineTagTree);
                    return (Void)super.visitUnknownInlineTag(unknownInlineTagTree, null);
                }
            }
            if (this.parameters.contains(name)) {
                String message = InvalidInlineTag.getMessageForInvalidTag(name);
                this.state.reportMatch(InvalidInlineTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix(Utils.replace(unknownInlineTagTree, String.format("{@code %s}", name), this.state)).build());
                this.fixedTags.add(unknownInlineTagTree);
                return (Void)super.visitUnknownInlineTag(unknownInlineTagTree, null);
            }
            if (this.isProbablyType(name)) {
                startPos = Utils.getStartPosition(unknownInlineTagTree, this.state);
                String message = String.format("The tag {@%1$s} is not valid, and will not display or cross-link to the type %1$s correctly. Prefer {@link %1$s}.", name);
                this.state.reportMatch(InvalidInlineTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix(SuggestedFix.replace(startPos, startPos + 2, "{@link ")).build());
                this.fixedTags.add(unknownInlineTagTree);
                return (Void)super.visitUnknownInlineTag(unknownInlineTagTree, null);
            }
            this.reportUnknownTag(unknownInlineTagTree, JavadocTag.inlineTag(name));
            return (Void)super.visitUnknownInlineTag(unknownInlineTagTree, null);
        }

        private boolean isProbablyType(String name) {
            Symbol typeSymbol = FindIdentifiers.findIdent(Iterables.getFirst(DOT_SPLITTER.split(name), null), this.state, Kinds.KindSelector.TYP);
            return typeSymbol instanceof Symbol.TypeSymbol || name.chars().filter(c -> c == 46).count() >= 3L || name.contains("#");
        }

        private void reportUnknownTag(DocTree docTree, JavadocTag tag) {
            Optional<String> bestMatch = Utils.getBestMatch(tag.name(), 2, this.context.validTags.stream().filter(t2 -> t2.type().equals((Object)tag.type())).map(JavadocTag::name).collect(ImmutableSet.toImmutableSet()));
            int pos = Utils.getStartPosition(docTree, this.state) + docTree.toString().indexOf(tag.name());
            String message = String.format("Tag name `%s` is unknown.", tag.name());
            this.state.reportMatch(bestMatch.map(bm -> InvalidInlineTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message + String.format(" Did you mean tag `%s`?", bm)).addFix(SuggestedFix.replace(pos, pos + tag.name().length(), bm)).build()).orElse(InvalidInlineTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message + " If this is a commonly-used custom tag, please click 'not useful' and file a bug.").build()));
            this.fixedTags.add(docTree);
        }

        @Override
        public Void scan(DocTree docTree, Void unused) {
            super.scan(docTree, null);
            if (this.fixedTags.contains(docTree)) {
                return null;
            }
            if (!(docTree instanceof DCTree.DCInlineTag)) {
                return null;
            }
            JavadocTag tag = JavadocTag.inlineTag(((DCTree.DCInlineTag)docTree).getTagName());
            if (this.context.validTags.contains(tag) || JavadocTag.KNOWN_OTHER_TAGS.contains(tag)) {
                return null;
            }
            String message = String.format("The tag @%s is not allowed on this type of element.", tag.name());
            this.state.reportMatch(InvalidInlineTag.this.buildDescription(Utils.diagnosticPosition(this.getCurrentPath(), this.state)).setMessage(message).addFix(Utils.replace(docTree, "", this.state)).build());
            return null;
        }
    }

    private static enum Context {
        CLASS(JavadocTag.VALID_CLASS_TAGS),
        METHOD(JavadocTag.VALID_METHOD_TAGS),
        VARIABLE(JavadocTag.VALID_VARIABLE_TAGS);

        final ImmutableSet<JavadocTag> validTags;
        final Pattern misplacedCurly;
        final Pattern parensRatherThanCurly;

        private Context(ImmutableSet<JavadocTag> validTags) {
            this.validTags = validTags;
            String validInlineTags = validTags.stream().filter(tag -> tag.type() == JavadocTag.TagType.INLINE).map(JavadocTag::name).collect(Collectors.joining("|"));
            this.misplacedCurly = Pattern.compile(String.format("@(%s)\\{", validInlineTags));
            this.parensRatherThanCurly = Pattern.compile(String.format("\\(@(%s)", validInlineTags));
        }
    }
}

