/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.guice;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.Modifier;

@BugPattern(name="GuiceInjectOnFinalField", summary="Although Guice allows injecting final fields, doing so is disallowed because the injected value may not be visible to other threads.", severity=BugPattern.SeverityLevel.ERROR)
public class InjectOnFinalField
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final Matcher<VariableTree> FINAL_FIELD_WITH_GUICE_INJECT = Matchers.allOf(Matchers.isField(), Matchers.hasModifier(Modifier.FINAL), Matchers.hasAnnotation("com.google.inject.Inject"));

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (FINAL_FIELD_WITH_GUICE_INJECT.matches(tree, state)) {
            return this.describeMatch(tree, (Fix)SuggestedFixes.removeModifiers(tree, state, Modifier.FINAL).orElse(SuggestedFix.emptyFix()));
        }
        return Description.NO_MATCH;
    }
}

