/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.guice;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;

@BugPattern(summary="This code declares a binding for a common value type without a Qualifier annotation.", severity=BugPattern.SeverityLevel.WARNING)
public class BindingToUnqualifiedCommonType
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<Tree> IS_SIMPLE_TYPE = Matchers.anyOf(Matchers.isPrimitiveOrBoxedPrimitiveType(), Matchers.isSameType(DayOfWeek.class), Matchers.isSameType(Duration.class), Matchers.isSameType(Instant.class), Matchers.isSameType(LocalDate.class), Matchers.isSameType(LocalDateTime.class), Matchers.isSameType(LocalTime.class), Matchers.isSameType(Month.class), Matchers.isSameType(MonthDay.class), Matchers.isSameType(OffsetDateTime.class), Matchers.isSameType(OffsetTime.class), Matchers.isSameType(Period.class), Matchers.isSameType(Year.class), Matchers.isSameType(YearMonth.class), Matchers.isSameType(ZonedDateTime.class), Matchers.isSameType(String.class), Matchers.isSameType(BigDecimal.class));
    private static final Matcher<MethodTree> PROVIDES_UNQUALIFIED_CONSTANT = Matchers.allOf(Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.isType("com.google.inject.Provides")), Matchers.not(Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf(Matchers.symbolHasAnnotation("com.google.inject.BindingAnnotation"), Matchers.symbolHasAnnotation("javax.inject.Qualifier")))), Matchers.methodReturns(IS_SIMPLE_TYPE));
    private static final Matcher<MethodInvocationTree> BIND_TO_UNQUALIFIED_CONSTANT = Matchers.allOf(Matchers.instanceMethod().onDescendantOf("com.google.inject.binder.LinkedBindingBuilder").namedAnyOf("to", "toInstance", "toProvider", "toConstructor"), Matchers.receiverOfInvocation(Matchers.methodInvocation(Matchers.anyOf(Matchers.instanceMethod().onDescendantOf("com.google.inject.AbstractModule").withSignature("<T>bind(java.lang.Class<T>)"), Matchers.instanceMethod().onDescendantOf("com.google.inject.Binder").withSignature("<T>bind(java.lang.Class<T>)")), ChildMultiMatcher.MatchType.ALL, Matchers.classLiteral(IS_SIMPLE_TYPE))));

    @Override
    public Description matchMethod(MethodTree method, VisitorState state) {
        if (PROVIDES_UNQUALIFIED_CONSTANT.matches(method, state) && !ASTHelpers.isJUnitTestCode(state)) {
            return this.describeMatch(method);
        }
        return Description.NO_MATCH;
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree methodInvocation, VisitorState state) {
        if (BIND_TO_UNQUALIFIED_CONSTANT.matches(methodInvocation, state) && !ASTHelpers.isJUnitTestCode(state)) {
            return this.describeMatch(methodInvocation);
        }
        return Description.NO_MATCH;
    }
}

