/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.dagger;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inject.dagger.DaggerAnnotations;
import com.google.errorprone.bugpatterns.inject.dagger.Util;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;

@BugPattern(summary="@Binds is a more efficient and declarative mechanism for delegating a binding.", severity=BugPattern.SeverityLevel.WARNING)
public class UseBinds
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<MethodTree> SIMPLE_METHOD = new Matcher<MethodTree>(){

        @Override
        public boolean matches(MethodTree t2, VisitorState state) {
            List<? extends VariableTree> parameters = t2.getParameters();
            if (parameters.size() != 1) {
                return false;
            }
            VariableTree onlyParameter = Iterables.getOnlyElement(parameters);
            BlockTree body = t2.getBody();
            if (body == null) {
                return false;
            }
            List<? extends StatementTree> statements = body.getStatements();
            if (statements.size() != 1) {
                return false;
            }
            StatementTree onlyStatement = Iterables.getOnlyElement(statements);
            if (!onlyStatement.getKind().equals((Object)Tree.Kind.RETURN)) {
                return false;
            }
            Symbol returnedSymbol = ASTHelpers.getSymbol(((ReturnTree)onlyStatement).getExpression());
            if (returnedSymbol == null) {
                return false;
            }
            return ASTHelpers.getSymbol(onlyParameter).equals(returnedSymbol);
        }
    };
    private static final Matcher<MethodTree> CAN_BE_A_BINDS_METHOD = Matchers.allOf(DaggerAnnotations.isBindingMethod(), SIMPLE_METHOD);

    @Override
    public Description matchMethod(MethodTree method, VisitorState state) {
        if (!CAN_BE_A_BINDS_METHOD.matches(method, state)) {
            return Description.NO_MATCH;
        }
        ClassTree enclosingClass = ASTHelpers.findEnclosingNode(state.getPath(), ClassTree.class);
        if (!Util.IS_DAGGER_2_MODULE.matches(enclosingClass, state)) {
            return Description.NO_MATCH;
        }
        if (enclosingClass.getExtendsClause() != null) {
            return UseBinds.fixByDelegating();
        }
        for (Tree tree : enclosingClass.getMembers()) {
            MethodTree siblingMethod;
            Set<Modifier> siblingFlags;
            if (!tree.getKind().equals((Object)Tree.Kind.METHOD) || ASTHelpers.getSymbol(tree).isConstructor() || (siblingFlags = (siblingMethod = (MethodTree)tree).getModifiers().getFlags()).contains((Object)Modifier.STATIC) || siblingFlags.contains((Object)Modifier.ABSTRACT) || CAN_BE_A_BINDS_METHOD.matches(siblingMethod, state)) continue;
            return UseBinds.fixByDelegating();
        }
        return this.fixByModifyingMethod(state, enclosingClass, method);
    }

    private Description fixByModifyingMethod(VisitorState state, ClassTree enclosingClass, MethodTree method) {
        return this.describeMatch(method, (Fix)SuggestedFix.builder().addImport("dagger.Binds").merge(UseBinds.convertMethodToBinds(method, enclosingClass, state)).merge(Util.makeConcreteClassAbstract(enclosingClass, state)).build());
    }

    private static SuggestedFix.Builder convertMethodToBinds(MethodTree method, ClassTree enclosingClass, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        ModifiersTree modifiers = method.getModifiers();
        ImmutableCollection.Builder modifierStringsBuilder = ImmutableList.builder().add("@Binds");
        for (AnnotationTree annotationTree : modifiers.getAnnotations()) {
            Name annotationQualifiedName = ASTHelpers.getSymbol(annotationTree).getQualifiedName();
            if (annotationQualifiedName.contentEquals("dagger.Provides") || annotationQualifiedName.contentEquals("dagger.producers.Produces")) {
                String typeName;
                List<? extends ExpressionTree> arguments = annotationTree.getArguments();
                if (arguments.isEmpty()) continue;
                ExpressionTree argument = Iterables.getOnlyElement(arguments);
                Preconditions.checkState(argument.getKind().equals((Object)Tree.Kind.ASSIGNMENT));
                AssignmentTree assignment = (AssignmentTree)argument;
                Preconditions.checkState(ASTHelpers.getSymbol(assignment.getVariable()).getSimpleName().contentEquals("type"));
                switch (typeName = ASTHelpers.getSymbol(assignment.getExpression()).getSimpleName().toString()) {
                    case "SET": {
                        ((ImmutableList.Builder)modifierStringsBuilder).add("@IntoSet");
                        fix.addImport("dagger.multibindings.IntoSet");
                        break;
                    }
                    case "SET_VALUES": {
                        ((ImmutableList.Builder)modifierStringsBuilder).add("@ElementsIntoSet");
                        fix.addImport("dagger.multibindings.ElementsIntoSet");
                        break;
                    }
                    case "MAP": {
                        ((ImmutableList.Builder)modifierStringsBuilder).add("@IntoMap");
                        fix.addImport("dagger.multibindings.IntoMap");
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown type name: " + typeName));
                    }
                }
                continue;
            }
            ((ImmutableList.Builder)modifierStringsBuilder).add(state.getSourceForNode(annotationTree));
        }
        HashSet<Modifier> methodFlags = new HashSet<Modifier>(modifiers.getFlags());
        methodFlags.remove((Object)Modifier.STATIC);
        methodFlags.remove((Object)Modifier.FINAL);
        if (!enclosingClass.getKind().equals((Object)Tree.Kind.INTERFACE)) {
            methodFlags.add(Modifier.ABSTRACT);
        }
        for (Modifier flag : methodFlags) {
            ((ImmutableList.Builder)modifierStringsBuilder).add(flag.toString());
        }
        fix.replace(modifiers, Joiner.on(' ').join(((ImmutableList.Builder)modifierStringsBuilder).build()));
        fix.replace(method.getBody(), ";");
        return fix;
    }

    private static Description fixByDelegating() {
        return Description.NO_MATCH;
    }
}

