/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.dagger;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;

@BugPattern(summary="Don't refer to Dagger's internal or generated code", severity=BugPattern.SeverityLevel.ERROR)
public final class RefersToDaggerCodegen
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final ImmutableSet<String> DAGGER_INTERNAL_PACKAGES = ImmutableSet.of("dagger.internal", "dagger.producers.internal", "dagger.producers.monitoring.internal", "dagger.android.internal");
    private static final ImmutableSet<String> GENERATED_BASE_TYPES = ImmutableSet.of("dagger.internal.Factory", "dagger.producers.internal.AbstractProducer");
    private static final ImmutableSet<String> DAGGER_1_GENERATED_BASE_TYPES = ImmutableSet.of("dagger.internal.Binding", "dagger.internal.ModuleAdapter");

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol method = ASTHelpers.getSymbol(tree);
        Symbol.ClassSymbol rootClassOfMethod = ASTHelpers.outermostClass(method);
        if (!(RefersToDaggerCodegen.isGeneratedFactoryType(rootClassOfMethod, state) || RefersToDaggerCodegen.isMembersInjectionInvocation(method, state) || RefersToDaggerCodegen.isDaggerInternalClass(rootClassOfMethod))) {
            return Description.NO_MATCH;
        }
        if (RefersToDaggerCodegen.isAllowedToReferenceDaggerInternals(state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }

    private static boolean isMembersInjectionInvocation(Symbol.MethodSymbol method, VisitorState state) {
        if (((Name)method.getSimpleName()).contentEquals("injectMembers")) {
            return false;
        }
        return RefersToDaggerCodegen.isGeneratedBaseType(ASTHelpers.outermostClass(method), state, "dagger.MembersInjector");
    }

    private static boolean isGeneratedFactoryType(Symbol.ClassSymbol symbol, VisitorState state) {
        return GENERATED_BASE_TYPES.stream().anyMatch(baseType -> RefersToDaggerCodegen.isGeneratedBaseType(symbol, state, baseType));
    }

    private static boolean isGeneratedBaseType(Symbol.ClassSymbol symbol, VisitorState state, String baseTypeName) {
        Type baseType = state.getTypeFromString(baseTypeName);
        return ASTHelpers.isSubtype((Type)symbol.asType(), baseType, state);
    }

    private static boolean isDaggerInternalClass(Symbol.ClassSymbol symbol) {
        return DAGGER_INTERNAL_PACKAGES.contains(ASTHelpers.enclosingPackage(symbol).getQualifiedName().toString());
    }

    private static boolean isAllowedToReferenceDaggerInternals(VisitorState state) {
        Symbol.ClassSymbol rootCallingClass = ASTHelpers.outermostClass(ASTHelpers.getSymbol((ClassTree)state.findEnclosing(ClassTree.class)));
        if (rootCallingClass.getQualifiedName().toString().startsWith("dagger.")) {
            return true;
        }
        ImmutableSet<String> generatedBy = ASTHelpers.getGeneratedBy(rootCallingClass, state);
        if (!generatedBy.isEmpty()) {
            return generatedBy.contains("dagger.internal.codegen.ComponentProcessor");
        }
        if (DAGGER_1_GENERATED_BASE_TYPES.stream().anyMatch(dagger1Type -> RefersToDaggerCodegen.isGeneratedBaseType(rootCallingClass, state, dagger1Type))) {
            return true;
        }
        return RefersToDaggerCodegen.isGeneratedBaseType(rootCallingClass, state, "dagger.MembersInjector") && rootCallingClass.getSimpleName().toString().contains("$$ParentAdapter");
    }
}

