/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.dagger;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inject.dagger.DaggerAnnotations;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.function.Predicate;

@BugPattern(summary="Add a private constructor to modules that will not be instantiated by Dagger.", severity=BugPattern.SeverityLevel.SUGGESTION)
public class PrivateConstructorForNoninstantiableModule
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    @Override
    public Description matchClass(ClassTree classTree, VisitorState state) {
        if (!DaggerAnnotations.isAnyModule().matches(classTree, state)) {
            return Description.NO_MATCH;
        }
        if (!classTree.getKind().equals((Object)Tree.Kind.CLASS)) {
            return Description.NO_MATCH;
        }
        ImmutableList nonSyntheticMembers = classTree.getMembers().stream().filter(tree -> !tree.getKind().equals((Object)Tree.Kind.METHOD) || !ASTHelpers.isGeneratedConstructor((MethodTree)tree)).collect(ImmutableList.toImmutableList());
        if (nonSyntheticMembers.isEmpty()) {
            return Description.NO_MATCH;
        }
        if (nonSyntheticMembers.stream().anyMatch(tree -> ASTHelpers.getSymbol(tree).isConstructor())) {
            return Description.NO_MATCH;
        }
        boolean hasBindingDeclarationMethods = nonSyntheticMembers.stream().anyMatch(PrivateConstructorForNoninstantiableModule.matcherAsPredicate(DaggerAnnotations.isBindingDeclarationMethod(), state));
        if (hasBindingDeclarationMethods) {
            return this.describeMatch(classTree, PrivateConstructorForNoninstantiableModule.addPrivateConstructor(classTree, state));
        }
        boolean allStaticMembers = nonSyntheticMembers.stream().allMatch(PrivateConstructorForNoninstantiableModule.matcherAsPredicate(Matchers.isStatic(), state));
        if (allStaticMembers) {
            return this.describeMatch(classTree, PrivateConstructorForNoninstantiableModule.addPrivateConstructor(classTree, state));
        }
        return Description.NO_MATCH;
    }

    private static Fix addPrivateConstructor(ClassTree classTree, VisitorState state) {
        return SuggestedFixes.addMembers(classTree, state, ASTHelpers.createPrivateConstructor(classTree), new String[0]);
    }

    private static <T extends Tree> Predicate<T> matcherAsPredicate(Matcher<? super T> matcher, VisitorState state) {
        return t2 -> matcher.matches(t2, state);
    }
}

