/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.dagger;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@BugPattern(summary="@Multibinds is a more efficient and declarative mechanism for ensuring that a set multibinding is present in the graph.", severity=BugPattern.SeverityLevel.WARNING)
public final class EmptySetMultibindingContributions
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<AnnotationTree> HAS_DAGGER_ONE_MODULE_ARGUMENT = Matchers.anyOf(Matchers.hasArgumentWithValue("injects", Matchers.anything()), Matchers.hasArgumentWithValue("staticInjections", Matchers.anything()), Matchers.hasArgumentWithValue("overrides", Matchers.anything()), Matchers.hasArgumentWithValue("addsTo", Matchers.anything()), Matchers.hasArgumentWithValue("complete", Matchers.anything()), Matchers.hasArgumentWithValue("library", Matchers.anything()));
    private static final Matcher<ExpressionTree> COLLECTIONS_EMPTY_SET = MethodMatchers.staticMethod().onClass(Collections.class.getCanonicalName()).named("emptySet");
    private static final Matcher<ExpressionTree> IMMUTABLE_SETS_OF = MethodMatchers.staticMethod().onClassAny(ImmutableSet.class.getCanonicalName(), ImmutableSortedSet.class.getCanonicalName()).named("of").withNoParameters();
    private static final Matcher<ExpressionTree> SET_CONSTRUCTORS = Matchers.anyOf(EmptySetMultibindingContributions.noArgSetConstructor(HashSet.class), EmptySetMultibindingContributions.noArgSetConstructor(LinkedHashSet.class), EmptySetMultibindingContributions.noArgSetConstructor(TreeSet.class));
    private static final Matcher<ExpressionTree> SET_FACTORY_METHODS = Matchers.anyOf(EmptySetMultibindingContributions.setFactory("newHashSet"), EmptySetMultibindingContributions.setFactory("newLinkedHashSet"), EmptySetMultibindingContributions.setFactory("newConcurrentHashSet"));
    private static final Matcher<ExpressionTree> ENUM_SET_NONE_OF = MethodMatchers.staticMethod().onClass(EnumSet.class.getCanonicalName()).named("noneOf");
    private static final Matcher<ExpressionTree> EMPTY_SET = Matchers.anyOf(COLLECTIONS_EMPTY_SET, IMMUTABLE_SETS_OF, SET_CONSTRUCTORS, SET_FACTORY_METHODS, ENUM_SET_NONE_OF);
    private static final Matcher<MethodTree> DIRECTLY_RETURNS_EMPTY_SET = Matchers.singleStatementReturnMatcher(EMPTY_SET);
    private static final Matcher<MethodTree> RETURNS_EMPTY_SET = new Matcher<MethodTree>(){

        @Override
        public boolean matches(MethodTree method, VisitorState state) {
            List<? extends VariableTree> parameters = method.getParameters();
            if (!parameters.isEmpty()) {
                return false;
            }
            return DIRECTLY_RETURNS_EMPTY_SET.matches(method, state);
        }
    };
    private static final Matcher<Tree> ANNOTATED_WITH_PRODUCES_OR_PROVIDES = Matchers.anyOf(Matchers.hasAnnotation("dagger.Provides"), Matchers.hasAnnotation("dagger.producers.Produces"));
    private static final Matcher<MethodTree> CAN_BE_A_MULTIBINDS_METHOD = Matchers.allOf(ANNOTATED_WITH_PRODUCES_OR_PROVIDES, Matchers.hasAnnotation("dagger.multibindings.ElementsIntoSet"), RETURNS_EMPTY_SET);

    private static Matcher<ExpressionTree> noArgSetConstructor(Class<? extends Set> setClass) {
        return MethodMatchers.constructor().forClass(setClass.getCanonicalName()).withNoParameters();
    }

    private static Matcher<ExpressionTree> setFactory(String factoryName) {
        return MethodMatchers.staticMethod().onClass(Sets.class.getCanonicalName()).named(factoryName).withNoParameters();
    }

    @Override
    public Description matchMethod(MethodTree method, VisitorState state) {
        if (!CAN_BE_A_MULTIBINDS_METHOD.matches(method, state)) {
            return Description.NO_MATCH;
        }
        JCTree.JCClassDecl enclosingClass = ASTHelpers.findEnclosingNode(state.getPath(), JCTree.JCClassDecl.class);
        for (JCTree.JCAnnotation annotation : enclosingClass.getModifiers().getAnnotations()) {
            if (!ASTHelpers.getSymbol(annotation.getAnnotationType()).getQualifiedName().contentEquals("dagger.Module") || !HAS_DAGGER_ONE_MODULE_ARGUMENT.matches(annotation, state)) continue;
            return Description.NO_MATCH;
        }
        return this.fixByModifyingMethod(state, enclosingClass, method);
    }

    private Description fixByModifyingMethod(VisitorState state, JCTree.JCClassDecl enclosingClass, MethodTree method) {
        JCTree.JCModifiers methodModifiers = ((JCTree.JCMethodDecl)method).getModifiers();
        String replacementModifiersString = EmptySetMultibindingContributions.createReplacementMethodModifiers(state, methodModifiers);
        JCTree.JCModifiers enclosingClassModifiers = enclosingClass.getModifiers();
        String enclosingClassReplacementModifiersString = EmptySetMultibindingContributions.createReplacementClassModifiers(state, enclosingClassModifiers);
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder().addImport("dagger.multibindings.Multibinds").replace(methodModifiers, replacementModifiersString).replace(method.getBody(), ";");
        fixBuilder = enclosingClassModifiers.pos == -1 ? fixBuilder.prefixWith(enclosingClass, enclosingClassReplacementModifiersString) : fixBuilder.replace(enclosingClassModifiers, enclosingClassReplacementModifiersString);
        return this.describeMatch(method, (Fix)fixBuilder.build());
    }

    private static String createReplacementMethodModifiers(VisitorState state, JCTree.JCModifiers modifiers) {
        ImmutableCollection.Builder modifierStringsBuilder = ImmutableList.builder().add("@Multibinds");
        for (JCTree.JCAnnotation annotation : modifiers.annotations) {
            Name annotationQualifiedName = ASTHelpers.getSymbol(annotation).getQualifiedName();
            if (annotationQualifiedName.contentEquals("dagger.Provides") || annotationQualifiedName.contentEquals("dagger.producers.Produces") || annotationQualifiedName.contentEquals("dagger.multibindings.ElementsIntoSet")) continue;
            ((ImmutableList.Builder)modifierStringsBuilder).add(state.getSourceForNode(annotation));
        }
        EnumSet<Flags.Flag> methodFlags = ASTHelpers.asFlagSet(modifiers.flags);
        methodFlags.remove((Object)Flags.Flag.STATIC);
        methodFlags.remove((Object)Flags.Flag.FINAL);
        methodFlags.add(Flags.Flag.ABSTRACT);
        for (Flags.Flag flag : methodFlags) {
            ((ImmutableList.Builder)modifierStringsBuilder).add(flag.toString());
        }
        return Joiner.on(' ').join(((ImmutableList.Builder)modifierStringsBuilder).build());
    }

    private static String createReplacementClassModifiers(VisitorState state, JCTree.JCModifiers enclosingClassModifiers) {
        ImmutableList.Builder classModifierStringsBuilder = ImmutableList.builder();
        for (JCTree.JCAnnotation annotation : enclosingClassModifiers.annotations) {
            classModifierStringsBuilder.add(state.getSourceForNode(annotation));
        }
        EnumSet<Flags.Flag> classFlags = ASTHelpers.asFlagSet(enclosingClassModifiers.flags);
        classFlags.remove((Object)Flags.Flag.FINAL);
        classFlags.add(Flags.Flag.ABSTRACT);
        for (Flags.Flag flag : classFlags) {
            classModifierStringsBuilder.add(flag.toString());
        }
        return Joiner.on(' ').join(classModifierStringsBuilder.build());
    }
}

