/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inject.ElementPredicates;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.lang.annotation.Retention;
import javax.annotation.Nullable;

@BugPattern(name="InjectScopeOrQualifierAnnotationRetention", summary="Scoping and qualifier annotations must have runtime retention.", severity=BugPattern.SeverityLevel.ERROR)
public class ScopeOrQualifierAnnotationRetention
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String RETENTION_ANNOTATION = "java.lang.annotation.Retention";
    private static final Matcher<ClassTree> SCOPE_OR_QUALIFIER_ANNOTATION_MATCHER = Matchers.allOf(Matchers.kindIs(Tree.Kind.ANNOTATION_TYPE), Matchers.anyOf(Matchers.hasAnnotation("com.google.inject.ScopeAnnotation"), Matchers.hasAnnotation("javax.inject.Scope"), Matchers.hasAnnotation("com.google.inject.BindingAnnotation"), Matchers.hasAnnotation("javax.inject.Qualifier"), Matchers.hasAnnotation("com.google.inject.multibindings.MapKey"), Matchers.hasAnnotation("dagger.MapKey")));
    private static final Supplier<Symbol> JAVA_LANG_ANNOTATION_RETENTION = VisitorState.memoize(state -> state.getSymbolFromString(RETENTION_ANNOTATION));

    @Override
    public final Description matchClass(ClassTree classTree, VisitorState state) {
        if (SCOPE_OR_QUALIFIER_ANNOTATION_MATCHER.matches(classTree, state)) {
            Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol(classTree);
            if (ElementPredicates.hasSourceRetention(classSymbol)) {
                return this.describe(classTree, state, ASTHelpers.getAnnotation(classSymbol, Retention.class));
            }
            if (!state.isAndroidCompatible() && ElementPredicates.doesNotHaveRuntimeRetention(classSymbol)) {
                ClassTree outer = ASTHelpers.findEnclosingNode(state.getPath(), ClassTree.class);
                if (outer != null && Matchers.allOf(InjectMatchers.IS_DAGGER_COMPONENT_OR_MODULE).matches(outer, state)) {
                    return Description.NO_MATCH;
                }
                return this.describe(classTree, state, ASTHelpers.getAnnotation(classSymbol, Retention.class));
            }
        }
        return Description.NO_MATCH;
    }

    private Description describe(ClassTree classTree, VisitorState state, @Nullable Retention retention) {
        if (retention == null) {
            AnnotationTree annotation = Iterables.getLast(classTree.getModifiers().getAnnotations());
            return this.describeMatch(classTree, (Fix)SuggestedFix.builder().addImport(RETENTION_ANNOTATION).addStaticImport("java.lang.annotation.RetentionPolicy.RUNTIME").postfixWith(annotation, "@Retention(RUNTIME)").build());
        }
        AnnotationTree retentionNode = null;
        for (AnnotationTree annotationTree : classTree.getModifiers().getAnnotations()) {
            if (!ASTHelpers.getSymbol(annotationTree).equals(JAVA_LANG_ANNOTATION_RETENTION.get(state))) continue;
            retentionNode = annotationTree;
        }
        return this.describeMatch(retentionNode, (Fix)SuggestedFix.builder().addImport(RETENTION_ANNOTATION).addStaticImport("java.lang.annotation.RetentionPolicy.RUNTIME").replace(retentionNode, "@Retention(RUNTIME)").build());
    }
}

