/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Abstract and default methods are not injectable with javax.inject.Inject", severity=BugPattern.SeverityLevel.ERROR)
public class JavaxInjectOnAbstractMethod
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final MultiMatcher<MethodTree, AnnotationTree> INJECT_FINDER = Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, InjectMatchers.IS_APPLICATION_OF_JAVAX_INJECT);
    private static final Matcher<MethodTree> ABSTRACT_OR_DEFAULT_METHOD_WITH_INJECT = Matchers.allOf(Matchers.anyOf(Matchers.hasModifier(Modifier.ABSTRACT), Matchers.hasModifier(Modifier.DEFAULT)));

    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        MultiMatcher.MultiMatchResult<AnnotationTree> injectAnnotations;
        if (ABSTRACT_OR_DEFAULT_METHOD_WITH_INJECT.matches(methodTree, state) && (injectAnnotations = INJECT_FINDER.multiMatchResult(methodTree, state)).matches()) {
            AnnotationTree injectAnnotation = injectAnnotations.onlyMatchingNode();
            return this.describeMatch(injectAnnotation, (Fix)SuggestedFix.delete(injectAnnotation));
        }
        return Description.NO_MATCH;
    }
}

