/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;

@BugPattern(summary="Injected constructors cannot be optional nor have binding annotations", severity=BugPattern.SeverityLevel.WARNING)
public class InjectedConstructorAnnotations
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<AnnotationTree> OPTIONAL_INJECTION_MATCHER = Matchers.allOf(Matchers.isType("com.google.inject.Inject"), Matchers.hasArgumentWithValue("optional", Matchers.booleanLiteral(true)));
    private static final Matcher<AnnotationTree> BINDING_ANNOTATION_MATCHER = new Matcher<AnnotationTree>(){

        @Override
        public boolean matches(AnnotationTree annotationTree, VisitorState state) {
            return Matchers.symbolHasAnnotation("com.google.inject.BindingAnnotation").matches(annotationTree.getAnnotationType(), state);
        }
    };

    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        SuggestedFix.Builder fix = null;
        if (InjectedConstructorAnnotations.isInjectedConstructor(methodTree, state)) {
            for (AnnotationTree annotationTree : methodTree.getModifiers().getAnnotations()) {
                if (OPTIONAL_INJECTION_MATCHER.matches(annotationTree, state)) {
                    if (fix == null) {
                        fix = SuggestedFix.builder();
                    }
                    fix = fix.replace(annotationTree, "@Inject");
                    continue;
                }
                if (!BINDING_ANNOTATION_MATCHER.matches(annotationTree, state)) continue;
                if (fix == null) {
                    fix = SuggestedFix.builder();
                }
                fix = fix.delete(annotationTree);
            }
        }
        if (fix == null) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(methodTree, (Fix)fix.build());
    }

    private static boolean isInjectedConstructor(MethodTree methodTree, VisitorState state) {
        return Matchers.allOf(Matchers.methodIsConstructor(), Matchers.hasAnnotation("com.google.inject.Inject")).matches(methodTree, state);
    }
}

