/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="@AutoFactory and @Inject should not be used in the same type.", severity=BugPattern.SeverityLevel.ERROR)
public class AutoFactoryAtInject
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final Matcher<Tree> HAS_AUTO_FACTORY_ANNOTATION = Matchers.hasAnnotation("com.google.auto.factory.AutoFactory");

    @Override
    public final Description matchAnnotation(AnnotationTree annotationTree, VisitorState state) {
        if (!InjectMatchers.IS_APPLICATION_OF_AT_INJECT.matches(annotationTree, state)) {
            return Description.NO_MATCH;
        }
        Tree annotatedTree = AutoFactoryAtInject.getCurrentlyAnnotatedNode(state);
        if (!annotatedTree.getKind().equals((Object)Tree.Kind.METHOD) || !Matchers.methodIsConstructor().matches((MethodTree)annotatedTree, state)) {
            return Description.NO_MATCH;
        }
        ClassTree classTree = ASTHelpers.findEnclosingNode(state.getPath(), ClassTree.class);
        ImmutableCollection potentiallyAnnotatedTrees = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(classTree)).addAll(ASTHelpers.getConstructors(classTree))).build();
        for (Tree potentiallyAnnotatedTree : potentiallyAnnotatedTrees) {
            if (!HAS_AUTO_FACTORY_ANNOTATION.matches(potentiallyAnnotatedTree, state) || !potentiallyAnnotatedTree.getKind().equals((Object)Tree.Kind.CLASS) && !potentiallyAnnotatedTree.equals(annotatedTree)) continue;
            return this.describeMatch(annotationTree, (Fix)SuggestedFix.delete(annotationTree));
        }
        return Description.NO_MATCH;
    }

    private static Tree getCurrentlyAnnotatedNode(VisitorState state) {
        return state.getPath().getParentPath().getParentPath().getLeaf();
    }
}

