/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.formatstring;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.formatstring.FormatStringUtils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.List;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.ElementKind;
import org.checkerframework.checker.nullness.qual.Nullable;

@BugPattern(summary="Prefer to create format strings inline, instead of extracting them to a single-use constant", severity=BugPattern.SeverityLevel.WARNING)
public class InlineFormatString
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<ExpressionTree> PRECONDITIONS_CHECK = Matchers.allOf(Matchers.anyOf(Matchers.staticMethod().onClass("com.google.common.base.Preconditions"), Matchers.staticMethod().onClass("com.google.common.base.Verify")), InlineFormatString::secondParameterIsString);

    private static boolean secondParameterIsString(ExpressionTree tree, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol(tree);
        if (!(symbol instanceof Symbol.MethodSymbol)) {
            return false;
        }
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
        return ((List)methodSymbol.getParameters()).size() >= 2 && ASTHelpers.isSubtype(((Symbol.VarSymbol)((List)methodSymbol.getParameters()).get((int)1)).type, state.getSymtab().stringType, state);
    }

    private static @Nullable ExpressionTree formatString(MethodInvocationTree tree, VisitorState state) {
        ImmutableList<ExpressionTree> args = FormatStringUtils.formatMethodArguments(tree, state);
        if (!args.isEmpty()) {
            return (ExpressionTree)args.get(0);
        }
        if (PRECONDITIONS_CHECK.matches(tree, state)) {
            return tree.getArguments().get(1);
        }
        return InlineFormatString.formatMethodAnnotationArguments(tree, state);
    }

    private static @Nullable ExpressionTree formatMethodAnnotationArguments(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol(tree);
        if (!ASTHelpers.hasAnnotation((Symbol)sym, FormatMethod.class, state)) {
            return null;
        }
        return tree.getArguments().get(InlineFormatString.formatStringIndex(state, sym));
    }

    private static int formatStringIndex(VisitorState state, Symbol.MethodSymbol sym) {
        int idx = 0;
        java.util.List parameters = sym.getParameters();
        for (Symbol.VarSymbol p : parameters) {
            if (ASTHelpers.hasAnnotation((Symbol)p, FormatString.class, state)) {
                return idx;
            }
            ++idx;
        }
        return 0;
    }

    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        Multimap uses = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        LinkedHashMap declarations = new LinkedHashMap();
        tree.accept(new TreeScanner<Void, Void>((SetMultimap)uses){
            final /* synthetic */ SetMultimap val$uses;
            {
                this.val$uses = setMultimap;
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                this.handle(tree);
                return (Void)super.visitMethodInvocation(tree, null);
            }

            private void handle(MethodInvocationTree tree) {
                ExpressionTree arg = InlineFormatString.formatString(tree, state);
                if (arg == null) {
                    return;
                }
                Symbol variable = ASTHelpers.getSymbol(arg);
                if (variable == null || variable.getKind() != ElementKind.FIELD || !variable.isPrivate() || ASTHelpers.constValue(arg, String.class) == null) {
                    return;
                }
                this.val$uses.put(variable, arg);
            }
        }, null);
        tree.accept(new TreeScanner<Void, Void>((SetMultimap)uses){
            final /* synthetic */ SetMultimap val$uses;
            {
                this.val$uses = setMultimap;
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree tree, Void unused) {
                this.handle(tree);
                return (Void)super.visitMemberSelect(tree, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                this.handle(tree);
                return (Void)super.visitIdentifier(tree, null);
            }

            private void handle(Tree tree) {
                Symbol sym = ASTHelpers.getSymbol(tree);
                if (sym == null) {
                    return;
                }
                if (this.val$uses.containsKey(sym) && !this.val$uses.containsValue(tree)) {
                    this.val$uses.removeAll(sym);
                }
            }
        }, null);
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(state, (SetMultimap)uses, declarations){
            final /* synthetic */ SetMultimap val$uses;
            final /* synthetic */ Map val$declarations;
            {
                this.val$uses = setMultimap;
                this.val$declarations = map;
                super(state);
            }

            @Override
            public Void visitVariable(VariableTree tree, Void unused) {
                Symbol.VarSymbol sym = ASTHelpers.getSymbol(tree);
                if (this.val$uses.containsKey(sym)) {
                    this.val$declarations.put(sym, tree);
                }
                return (Void)super.visitVariable(tree, null);
            }
        }.scan(state.getPath(), null);
        for (Map.Entry e : uses.asMap().entrySet()) {
            Symbol sym = (Symbol)e.getKey();
            Collection use = e.getValue();
            VariableTree def = (VariableTree)declarations.get(sym);
            if (def == null || !(def.getInitializer() instanceof LiteralTree)) continue;
            String constValue = state.getSourceForNode(def.getInitializer());
            SuggestedFix.Builder fix = SuggestedFix.builder();
            if (use.size() > 1) continue;
            fix.delete(def);
            for (Tree u : use) {
                fix.replace(u, constValue);
            }
            state.reportMatch(this.describeMatch(def, (Fix)fix.build()));
        }
        return Description.NO_MATCH;
    }
}

