/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.formatstring;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;
import java.util.Locale;

public final class FormatStringUtils {
    private static final Matcher<ExpressionTree> FORMAT_METHOD = Matchers.anyOf(MethodMatchers.instanceMethod().onDescendantOfAny("java.io.PrintStream", "java.io.PrintWriter", "java.util.Formatter", "java.io.Console").namedAnyOf("format", "printf"), MethodMatchers.staticMethod().onClass("java.lang.String").named("format"), MethodMatchers.instanceMethod().onExactClass("java.io.Console").withSignature("readPassword(java.lang.String,java.lang.Object...)"), MethodMatchers.instanceMethod().onExactClass("java.io.Console").withSignature("readLine(java.lang.String,java.lang.Object...)"));

    public static ImmutableList<ExpressionTree> formatMethodArguments(MethodInvocationTree tree, VisitorState state) {
        if (!FORMAT_METHOD.matches(tree, state)) {
            return ImmutableList.of();
        }
        List<ExpressionTree> args = ImmutableList.copyOf(tree.getArguments());
        if (ASTHelpers.isSameType(ASTHelpers.getType((Tree)args.get(0)), state.getTypeFromString(Locale.class.getName()), state)) {
            args = args.subList(1, args.size());
        }
        return args;
    }

    private FormatStringUtils() {
    }
}

