/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.flogger;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.CompileTimeConstantExpressionMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="Arguments to log(String) must be compile-time constants or parameters annotated with @CompileTimeConstant. If possible, use Flogger's formatting log methods instead.", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.ERROR)
public class FloggerLogString
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> LOG_STRING = Matchers.instanceMethod().onDescendantOf("com.google.common.flogger.LoggingApi").named("log").withParameters("java.lang.String", new String[0]);
    private static final Matcher<ExpressionTree> COMPILE_TIME_CONSTANT = CompileTimeConstantExpressionMatcher.instance();

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return LOG_STRING.matches(tree, state) && !COMPILE_TIME_CONSTANT.matches(tree.getArguments().get(0), state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

