/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.flogger;

import com.google.common.base.Ascii;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.flogger.FloggerHelpers;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Type;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.lang.model.type.TypeKind;

@BugPattern(summary="Use Flogger's printf-style formatting instead of explicitly converting arguments to strings", severity=BugPattern.SeverityLevel.WARNING)
public class FloggerArgumentToString
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Pattern PRINTF_TERM_CAPTURE_PATTERN = Pattern.compile("[^%]*+(?:%%[^%]*+)*+(%[^%a-zA-Z]*[a-zA-Z])");
    private static final Pattern PRINTF_TERM_VALIDATION_PATTERN = Pattern.compile("[cCbBn]|#?(?:[1-9][0-9]*)?[sS]|,?(?:[1-9][0-9]*)?d|0[1-9][0-9]*d|#?(?:0[1-9][0-9]*)?[xX]|,?(?:[1-9][0-9]*)?(?:\\.[0-9]+)?[feEgG]");
    private static final Character STRING_FORMAT = Character.valueOf('s');
    private static final Character UPPER_STRING_FORMAT = Character.valueOf('S');
    private static final Character HEX_FORMAT = Character.valueOf('x');
    private static final Character UPPER_HEX_FORMAT = Character.valueOf('X');
    private static final com.google.errorprone.matchers.Matcher<ExpressionTree> LOG_MATCHER = MethodMatchers.instanceMethod().onDescendantOf("com.google.common.flogger.LoggingApi").named("log");
    static final com.google.errorprone.matchers.Matcher<ExpressionTree> UNWRAPPABLE = Matchers.anyOf(Arrays.stream(Unwrapper.values()).map(u -> u.matcher).collect(ImmutableList.toImmutableList()));

    private static ExpressionTree getOnlyArgument(MethodInvocationTree invocation) {
        return Iterables.getOnlyElement(invocation.getArguments());
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!LOG_MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (arguments.isEmpty()) {
            return Description.NO_MATCH;
        }
        String formatString = ASTHelpers.constValue(arguments.get(0), String.class);
        if (formatString == null) {
            return Description.NO_MATCH;
        }
        if ((arguments = arguments.subList(1, arguments.size())).stream().noneMatch(argument -> UNWRAPPABLE.matches((ExpressionTree)argument, state))) {
            return Description.NO_MATCH;
        }
        return this.unwrapArguments(formatString, tree, arguments, state);
    }

    Description unwrapArguments(String formatString, MethodInvocationTree tree, List<? extends ExpressionTree> arguments, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        int start = 0;
        Matcher matcher = PRINTF_TERM_CAPTURE_PATTERN.matcher(formatString);
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        boolean fixed = false;
        while (matcher.find() && matcher.start() == start) {
            Object term = matcher.group(1);
            if (!PRINTF_TERM_VALIDATION_PATTERN.matcher(((String)term).substring(1)).matches()) {
                return Description.NO_MATCH;
            }
            if (((String)term).equals("%n")) {
                term = "\\n";
            } else {
                char placeholder;
                ExpressionTree argument;
                Parameter unwrapped;
                if (((String)term).length() == 2 && (unwrapped = FloggerArgumentToString.unwrap(argument = arguments.get(idx), placeholder = ((String)term).charAt(1), state)) != null) {
                    fix.replace(argument, unwrapped.source.get(state));
                    placeholder = MoreObjects.firstNonNull(unwrapped.placeholder, Character.valueOf('s')).charValue();
                    if (placeholder == STRING_FORMAT.charValue()) {
                        placeholder = FloggerHelpers.inferFormatSpecifier(unwrapped.type, state);
                    }
                    term = "%" + placeholder;
                    fixed = true;
                }
                ++idx;
            }
            sb.append(formatString, start, matcher.start(1)).append((String)term);
            start = matcher.end(1);
        }
        sb.append(formatString, start, formatString.length());
        if (!fixed) {
            return Description.NO_MATCH;
        }
        fix.replace(tree.getArguments().get(0), state.getConstantExpression(sb.toString()));
        return this.describeMatch(tree, (Fix)fix.build());
    }

    @Nullable
    private static Parameter unwrap(ExpressionTree argument, char placeholder, VisitorState state) {
        for (Unwrapper unwrapper : Unwrapper.values()) {
            if (!unwrapper.matcher.matches(argument, state)) continue;
            return unwrapper.unwrap((MethodInvocationTree)argument, placeholder);
        }
        return null;
    }

    private static boolean hasSingleVarargsCompatibleArgument(MethodInvocationTree tree, VisitorState state) {
        if (tree.getArguments().size() != 1) {
            return false;
        }
        Type type = ASTHelpers.getType(FloggerArgumentToString.getOnlyArgument(tree));
        if (type == null) {
            return false;
        }
        if (!type.getKind().equals((Object)TypeKind.ARRAY)) {
            return false;
        }
        return ASTHelpers.isSameType(((Type.ArrayType)type).getComponentType(), state.getSymtab().objectType, state);
    }

    private static enum Unwrapper {
        TO_STRING((com.google.errorprone.matchers.Matcher)MethodMatchers.instanceMethod().anyClass().named("toString").withNoParameters()){

            @Override
            Parameter unwrap(MethodInvocationTree invocation, char placeholder) {
                return Parameter.receiver(invocation, placeholder);
            }
        }
        ,
        STRING_VALUE_OF(Matchers.anyOf((Iterable)Stream.of("valueOf(boolean)", "valueOf(char)", "valueOf(int)", "valueOf(long)", "valueOf(float)", "valueOf(double)", "valueOf(java.lang.Object)").map(signature -> MethodMatchers.instanceMethod().onExactClass("java.lang.String").withSignature((String)signature)).collect(ImmutableList.toImmutableList()))){

            @Override
            Parameter unwrap(MethodInvocationTree invocation, char placeholder) {
                return Parameter.receiver(invocation, placeholder);
            }
        }
        ,
        STATIC_TO_STRING(Matchers.anyOf((Iterable)ImmutableMap.builder().put(Boolean.class, "toString(boolean)").put(Character.class, "toString(char)").put(Byte.class, "toString(byte)").put(Short.class, "toString(short)").put(Integer.class, "toString(int)").put(Long.class, "toString(long)").put(Float.class, "toString(float)").put(Double.class, "toString(double)").buildOrThrow().entrySet().stream().map(e -> MethodMatchers.staticMethod().onClass(((Class)e.getKey()).getName()).withSignature((String)e.getValue())).collect(ImmutableList.toImmutableList()))){

            @Override
            Parameter unwrap(MethodInvocationTree invocation, char placeholder) {
                return new Parameter(FloggerArgumentToString.getOnlyArgument(invocation), placeholder);
            }
        }
        ,
        STATIC_VALUE_OF(Matchers.anyOf((Iterable)ImmutableMap.builder().put(Boolean.class, "valueOf(boolean)").put(Character.class, "valueOf(char)").put(Byte.class, "valueOf(byte)").put(Short.class, "valueOf(short)").put(Integer.class, "valueOf(int)").put(Long.class, "valueOf(long)").put(Float.class, "valueOf(float)").put(Double.class, "valueOf(double)").buildOrThrow().entrySet().stream().map(e -> MethodMatchers.staticMethod().onClass(((Class)e.getKey()).getName()).withSignature((String)e.getValue())).collect(ImmutableList.toImmutableList()))){

            @Override
            Parameter unwrap(MethodInvocationTree invocation, char placeholder) {
                return new Parameter(FloggerArgumentToString.getOnlyArgument(invocation), placeholder);
            }
        }
        ,
        STRING_TO_UPPER_CASE((com.google.errorprone.matchers.Matcher)MethodMatchers.instanceMethod().onExactClass("java.lang.String").named("toUpperCase").withNoParameters()){

            @Override
            Parameter unwrap(MethodInvocationTree invocation, char placeholder) {
                return new Parameter(ASTHelpers.getReceiver(invocation), UPPER_STRING_FORMAT.charValue());
            }
        }
        ,
        ASCII_TO_UPPER_CASE(Matchers.anyOf((Iterable)Stream.of("java.lang.String", "java.lang.CharSequence").map(param -> MethodMatchers.staticMethod().onClass("com.google.common.base.Ascii").named("toUpperCase").withParameters((String)param, new String[0])).collect(ImmutableList.toImmutableList()))){

            @Override
            Parameter unwrap(MethodInvocationTree invocation, char placeholder) {
                return new Parameter(FloggerArgumentToString.getOnlyArgument(invocation), UPPER_STRING_FORMAT.charValue());
            }
        }
        ,
        STATIC_TO_HEX_STRING(Matchers.anyOf((Iterable)ImmutableMap.builder().put(Integer.class, "toHexString(int)").put(Long.class, "toHexString(long)").buildOrThrow().entrySet().stream().map(e -> MethodMatchers.staticMethod().onClass(((Class)e.getKey()).getName()).withSignature((String)e.getValue())).collect(ImmutableList.toImmutableList()))){

            @Override
            Parameter unwrap(MethodInvocationTree invocation, char placeholder) {
                return new Parameter(FloggerArgumentToString.getOnlyArgument(invocation), (Ascii.isUpperCase(placeholder) ? UPPER_HEX_FORMAT : HEX_FORMAT).charValue());
            }
        }
        ,
        ARRAYS_AS_LIST_OR_TO_STRING(Matchers.allOf(MethodMatchers.staticMethod().onClass("java.util.Arrays").namedAnyOf("asList", "toString"), Matchers.toType(MethodInvocationTree.class, (x$0, x$1) -> FloggerArgumentToString.hasSingleVarargsCompatibleArgument(x$0, x$1)))){

            @Override
            Parameter unwrap(MethodInvocationTree invocation, char placeholder) {
                return new Parameter(FloggerArgumentToString.getOnlyArgument(invocation), placeholder);
            }
        };

        private final com.google.errorprone.matchers.Matcher<ExpressionTree> matcher;

        abstract Parameter unwrap(MethodInvocationTree var1, char var2);

        private Unwrapper(com.google.errorprone.matchers.Matcher<ExpressionTree> matcher) {
            this.matcher = matcher;
        }
    }

    static class Parameter {
        final Supplier<String> source;
        final Type type;
        @Nullable
        final Character placeholder;

        private Parameter(ExpressionTree expression, char placeholder) {
            this(s2 -> s2.getSourceForNode(expression), ASTHelpers.getType(expression), placeholder);
        }

        private Parameter(Supplier<String> source, Type type, char placeholder) {
            this.source = source;
            this.type = type;
            this.placeholder = Character.valueOf(placeholder);
        }

        private static Parameter receiver(MethodInvocationTree invocation, char placeholder) {
            ExpressionTree receiver = ASTHelpers.getReceiver(invocation);
            if (receiver != null) {
                return new Parameter(ASTHelpers.getReceiver(invocation), placeholder);
            }
            return new Parameter(s2 -> "this", null, placeholder);
        }
    }
}

