/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.common.collect.Iterables;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AbstractCollectionIncompatibleTypeMatcher;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Type;
import java.util.Optional;
import javax.annotation.Nullable;

final class MethodArgMatcher
extends AbstractCollectionIncompatibleTypeMatcher {
    private final Matcher<ExpressionTree> methodMatcher;
    private final String typeName;
    private final int typeArgIndex;
    private final int methodArgIndex;

    MethodArgMatcher(String typeName, String signature, int typeArgIndex, int methodArgIndex) {
        this.methodMatcher = MethodMatchers.instanceMethod().onDescendantOf(typeName).withSignature(signature);
        this.typeName = typeName;
        this.typeArgIndex = typeArgIndex;
        this.methodArgIndex = methodArgIndex;
    }

    @Override
    Matcher<ExpressionTree> methodMatcher() {
        return this.methodMatcher;
    }

    @Override
    ExpressionTree extractSourceTree(MethodInvocationTree tree, VisitorState state) {
        return Iterables.get(tree.getArguments(), this.methodArgIndex);
    }

    @Override
    @Nullable
    ExpressionTree extractSourceTree(MemberReferenceTree tree, VisitorState state) {
        return tree;
    }

    @Override
    Type extractSourceType(MethodInvocationTree tree, VisitorState state) {
        return ASTHelpers.getType(this.extractSourceTree(tree, state));
    }

    @Override
    @Nullable
    Type extractSourceType(MemberReferenceTree tree, VisitorState state) {
        return state.getTypes().findDescriptorType(ASTHelpers.getType(tree)).getParameterTypes().get(0);
    }

    @Override
    Type extractTargetType(MethodInvocationTree tree, VisitorState state) {
        return MethodArgMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getReceiverType(tree), state.getSymbolFromString(this.typeName), this.typeArgIndex, state.getTypes());
    }

    @Override
    @Nullable
    Type extractTargetType(MemberReferenceTree tree, VisitorState state) {
        return MethodArgMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getReceiverType(tree), state.getSymbolFromString(this.typeName), this.typeArgIndex, state.getTypes());
    }

    @Override
    Optional<Fix> buildFix(AbstractCollectionIncompatibleTypeMatcher.MatchResult result) {
        return Optional.of(SuggestedFix.prefixWith(result.sourceTree(), "(Object) "));
    }

    @Override
    public String message(AbstractCollectionIncompatibleTypeMatcher.MatchResult result, String sourceType, String targetType) {
        return String.format("Argument '%s' should not be passed to this method; its type %s is not compatible with its collection's type argument %s", result.sourceTree(), sourceType, targetType);
    }
}

