/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableListMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.CompatibleWith;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.TypeCompatibilityUtils;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AbstractCollectionIncompatibleTypeMatcher;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AutoValue_IncompatibleArgumentType_RequiredType;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeParameterElement;

@BugPattern(summary="Passing argument to a generic method with an incompatible type.", severity=BugPattern.SeverityLevel.ERROR)
public class IncompatibleArgumentType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private final TypeCompatibilityUtils typeCompatibilityUtils;

    @Inject
    public IncompatibleArgumentType(ErrorProneFlags flags) {
        this.typeCompatibilityUtils = TypeCompatibilityUtils.fromFlags(flags);
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        Type calledMethodType = ASTHelpers.getType(methodInvocationTree.getMethodSelect());
        Type calledClazzType = ASTHelpers.getReceiverType(methodInvocationTree);
        java.util.List<? extends ExpressionTree> arguments = methodInvocationTree.getArguments();
        Symbol.MethodSymbol declaredMethod = ASTHelpers.getSymbol(methodInvocationTree);
        if (arguments.isEmpty()) {
            return Description.NO_MATCH;
        }
        ArrayList<Object> requiredTypesAtCallSite = new ArrayList<Object>(Collections.nCopies(arguments.size(), null));
        Types types = state.getTypes();
        if (!IncompatibleArgumentType.populateTypesToEnforce(declaredMethod, calledMethodType, calledClazzType, requiredTypesAtCallSite, state)) {
            for (Symbol.MethodSymbol method : ASTHelpers.findSuperMethods(declaredMethod, types)) {
                if (IncompatibleArgumentType.populateTypesToEnforce(method, calledMethodType, calledClazzType, requiredTypesAtCallSite, state)) break;
            }
        }
        this.reportAnyViolations(arguments, requiredTypesAtCallSite, state);
        return Description.NO_MATCH;
    }

    private void reportAnyViolations(java.util.List<? extends ExpressionTree> arguments, java.util.List<RequiredType> requiredArgumentTypes, VisitorState state) {
        Types types = state.getTypes();
        for (int i = 0; i < requiredArgumentTypes.size(); ++i) {
            TypeCompatibilityUtils.TypeCompatibilityReport report;
            RequiredType requiredType = requiredArgumentTypes.get(i);
            if (requiredType == null) continue;
            ExpressionTree argument = arguments.get(i);
            Type argType = ASTHelpers.getType(argument);
            if (requiredType.type() == null || (report = this.typeCompatibilityUtils.compatibilityOfTypes(requiredType.type(), argType, state)).isCompatible()) continue;
            state.reportMatch(this.describeViolation(argument, argType, requiredType.type(), types, state));
        }
    }

    private Description describeViolation(ExpressionTree argument, Type argType, Type requiredType, Types types, VisitorState state) {
        String targetType;
        String sourceType = Signatures.prettyType(argType);
        if (sourceType.equals(targetType = Signatures.prettyType(ASTHelpers.getUpperBound(requiredType, types)))) {
            sourceType = argType.toString();
            targetType = requiredType.toString();
        }
        String msg = String.format("Argument '%s' should not be passed to this method. Its type %s is not compatible with the required type: %s.", state.getSourceForNode(argument), sourceType, targetType);
        return this.buildDescription(argument).setMessage(msg).build();
    }

    @CheckReturnValue
    private static boolean populateTypesToEnforce(Symbol.MethodSymbol declaredMethod, Type calledMethodType, Type calledReceiverType, java.util.List<RequiredType> argumentTypeRequirements, VisitorState state) {
        boolean foundAnyTypeToEnforce = false;
        List<Symbol.VarSymbol> params = declaredMethod.params();
        for (int i = 0; i < params.size(); ++i) {
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)params.get(i);
            CompatibleWith anno = ASTHelpers.getAnnotation(varSymbol, CompatibleWith.class);
            if (anno == null) continue;
            foundAnyTypeToEnforce = true;
            RequiredType requiredType = IncompatibleArgumentType.resolveRequiredTypeForThisCall(state, calledMethodType, calledReceiverType, declaredMethod, anno.value());
            if (declaredMethod.isVarArgs() && i == params.size() - 1) {
                if (i >= argumentTypeRequirements.size()) break;
                for (int j = i; j < argumentTypeRequirements.size(); ++j) {
                    argumentTypeRequirements.set(j, requiredType);
                }
                continue;
            }
            argumentTypeRequirements.set(i, requiredType);
        }
        return foundAnyTypeToEnforce;
    }

    @Nullable
    @CheckReturnValue
    private static RequiredType resolveRequiredTypeForThisCall(VisitorState state, Type calledMethodType, Type calledReceiverType, Symbol.MethodSymbol declaredMethod, String typeArgName) {
        RequiredType requiredType = IncompatibleArgumentType.resolveTypeFromGenericMethod(calledMethodType, declaredMethod, typeArgName);
        if (requiredType == null) {
            requiredType = IncompatibleArgumentType.resolveTypeFromClass(calledReceiverType, (Symbol.ClassSymbol)declaredMethod.owner, typeArgName, state);
        }
        return requiredType;
    }

    @Nullable
    private static RequiredType resolveTypeFromGenericMethod(Type calledMethodType, Symbol.MethodSymbol declaredMethod, String typeArgName) {
        int tyargIndex = IncompatibleArgumentType.findTypeArgInList(declaredMethod, typeArgName);
        return tyargIndex == -1 ? null : RequiredType.create(IncompatibleArgumentType.getTypeFromTypeMapping(calledMethodType, declaredMethod, typeArgName));
    }

    @Nullable
    private static Type getTypeFromTypeMapping(Type m4, Symbol.MethodSymbol declaredMethod, String namedTypeArg) {
        ImmutableListMultimap<Symbol.TypeVariableSymbol, Type> substitutions = ASTHelpers.getTypeSubstitution(m4, declaredMethod);
        for (Map.Entry e : substitutions.entries()) {
            if (!((Name)((Symbol.TypeVariableSymbol)e.getKey()).getSimpleName()).contentEquals(namedTypeArg)) continue;
            return (Type)e.getValue();
        }
        return null;
    }

    @Nullable
    private static RequiredType resolveTypeFromClass(Type calledType, Symbol.ClassSymbol clazzSymbol, String typeArgName, VisitorState state) {
        int tyargIndex = IncompatibleArgumentType.findTypeArgInList(clazzSymbol, typeArgName);
        if (tyargIndex != -1) {
            return RequiredType.create(AbstractCollectionIncompatibleTypeMatcher.extractTypeArgAsMemberOfSupertype(calledType, clazzSymbol, tyargIndex, state.getTypes()));
        }
        while (clazzSymbol.isInner()) {
            Symbol.ClassSymbol encloser = clazzSymbol.owner.enclClass();
            calledType = calledType.getEnclosingType();
            tyargIndex = IncompatibleArgumentType.findTypeArgInList(encloser, typeArgName);
            if (tyargIndex != -1) {
                if (calledType.getTypeArguments().isEmpty()) {
                    return null;
                }
                return RequiredType.create(calledType.getTypeArguments().get(tyargIndex));
            }
            clazzSymbol = encloser;
        }
        return null;
    }

    private static int findTypeArgInList(Parameterizable hasTypeParams, String typeArgName) {
        java.util.List<? extends TypeParameterElement> typeParameters = hasTypeParams.getTypeParameters();
        for (int i = 0; i < typeParameters.size(); ++i) {
            if (!typeParameters.get(i).getSimpleName().contentEquals(typeArgName)) continue;
            return i;
        }
        return -1;
    }

    @AutoValue
    static abstract class RequiredType {
        RequiredType() {
        }

        @Nullable
        abstract Type type();

        static RequiredType create(Type type) {
            return new AutoValue_IncompatibleArgumentType_RequiredType(type);
        }
    }
}

