/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AbstractCollectionIncompatibleTypeMatcher;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Type;
import javax.annotation.Nullable;

final class BinopMatcher
extends AbstractCollectionIncompatibleTypeMatcher {
    private final Matcher<ExpressionTree> matcher;
    private final String collectionType;

    BinopMatcher(String collectionType, String className, String methodName) {
        this.collectionType = collectionType;
        this.matcher = Matchers.staticMethod().onClass(className).named(methodName);
    }

    @Override
    Matcher<ExpressionTree> methodMatcher() {
        return this.matcher;
    }

    @Override
    @Nullable
    Type extractSourceType(MethodInvocationTree tree, VisitorState state) {
        return BinopMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType(tree.getArguments().get(0)), state.getSymbolFromString(this.collectionType), 0, state.getTypes());
    }

    @Override
    @Nullable
    Type extractSourceType(MemberReferenceTree tree, VisitorState state) {
        Type descriptorType = state.getTypes().findDescriptorType(ASTHelpers.getType(tree));
        return BinopMatcher.extractTypeArgAsMemberOfSupertype(descriptorType.getParameterTypes().get(0), state.getSymbolFromString(this.collectionType), 0, state.getTypes());
    }

    @Override
    @Nullable
    ExpressionTree extractSourceTree(MethodInvocationTree tree, VisitorState state) {
        return tree.getArguments().get(0);
    }

    @Override
    @Nullable
    ExpressionTree extractSourceTree(MemberReferenceTree tree, VisitorState state) {
        return tree;
    }

    @Override
    @Nullable
    Type extractTargetType(MethodInvocationTree tree, VisitorState state) {
        return BinopMatcher.extractTypeArgAsMemberOfSupertype(ASTHelpers.getType(tree.getArguments().get(1)), state.getSymbolFromString(this.collectionType), 0, state.getTypes());
    }

    @Override
    @Nullable
    Type extractTargetType(MemberReferenceTree tree, VisitorState state) {
        Type descriptorType = state.getTypes().findDescriptorType(ASTHelpers.getType(tree));
        return BinopMatcher.extractTypeArgAsMemberOfSupertype(descriptorType.getParameterTypes().get(1), state.getSymbolFromString(this.collectionType), 0, state.getTypes());
    }

    @Override
    protected String message(AbstractCollectionIncompatibleTypeMatcher.MatchResult result, String sourceType, String targetType) {
        return String.format("Argument '%s' should not be passed to this method; its type %s is not compatible with %s", result.sourceTree(), sourceType, targetType);
    }
}

