/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.bugpatterns.checkreturnvalue.AutoValue_ResultUseRule_Evaluation;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUsePolicy;
import java.util.Optional;

public abstract class ResultUseRule<C, S> {
    public abstract String id();

    public abstract ImmutableSet<RuleScope> scopes();

    public abstract Optional<ResultUsePolicy> evaluate(S var1, C var2);

    public final Optional<Evaluation<S>> evaluate(RuleScope scope, S symbol, C context) {
        return this.evaluate(symbol, context).map(policy -> Evaluation.create(this, scope, symbol, policy));
    }

    public final String toString() {
        return this.id();
    }

    @AutoValue
    public static abstract class Evaluation<S> {
        public static <S> Evaluation<S> create(ResultUseRule<?, S> rule, RuleScope scope, S element, ResultUsePolicy policy) {
            return new AutoValue_ResultUseRule_Evaluation<S>(rule, scope, element, policy);
        }

        public abstract ResultUseRule<?, S> rule();

        public abstract RuleScope scope();

        public abstract S element();

        public abstract ResultUsePolicy policy();
    }

    public static enum RuleScope {
        METHOD,
        ENCLOSING_ELEMENTS,
        GLOBAL;

    }

    public static abstract class GlobalRule<C, S>
    extends ResultUseRule<C, S> {
        private static final ImmutableSet<RuleScope> SCOPES = ImmutableSet.of(RuleScope.GLOBAL);

        @Override
        public final ImmutableSet<RuleScope> scopes() {
            return SCOPES;
        }
    }

    public static abstract class SymbolRule<C, S>
    extends ResultUseRule<C, S> {
        private static final ImmutableSet<RuleScope> SCOPES = ImmutableSet.of(RuleScope.METHOD, RuleScope.ENCLOSING_ELEMENTS);

        @Override
        public final ImmutableSet<RuleScope> scopes() {
            return SCOPES;
        }
    }

    public static abstract class MethodRule<C, S, M extends S>
    extends ResultUseRule<C, S> {
        private static final ImmutableSet<RuleScope> SCOPES = ImmutableSet.of(RuleScope.METHOD);
        private final Class<M> methodSymbolClass;

        protected MethodRule(Class<M> methodSymbolClass) {
            this.methodSymbolClass = methodSymbolClass;
        }

        @Override
        public final ImmutableSet<RuleScope> scopes() {
            return SCOPES;
        }

        public abstract Optional<ResultUsePolicy> evaluateMethod(M var1, C var2);

        @Override
        public final Optional<ResultUsePolicy> evaluate(S symbol, C context) {
            return this.methodSymbolClass.isInstance(symbol) ? this.evaluateMethod(this.methodSymbolClass.cast(symbol), context) : Optional.empty();
        }
    }
}

