/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUsePolicy;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUseRule;
import com.google.errorprone.bugpatterns.checkreturnvalue.Rules;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Optional;
import java.util.regex.Pattern;

public final class ProtoRules {
    private ProtoRules() {
    }

    public static ResultUseRule<VisitorState, Symbol> protoBuilders() {
        return new ProtoRule(TypePredicates.isDescendantOfAny(ImmutableSet.of("com.google.protobuf.MessageLite.Builder")), "PROTO_BUILDER");
    }

    public static ResultUseRule<VisitorState, Symbol> mutableProtos() {
        return new ProtoRule(TypePredicates.isDescendantOfAny(ImmutableSet.of("com.google.protobuf.AbstractMutableMessageLite")), "MUTABLE_PROTO");
    }

    private static final class ProtoRule
    extends Rules.ErrorProneMethodRule {
        private static final Pattern NAMED_MUTATOR_METHOD = Pattern.compile("(add|clear|insert|merge|remove|set|put).*");
        private final TypePredicate typePredicate;
        private final String id;

        ProtoRule(TypePredicate typePredicate, String id) {
            this.typePredicate = Preconditions.checkNotNull(typePredicate);
            this.id = Preconditions.checkNotNull(id);
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public Optional<ResultUsePolicy> evaluateMethod(Symbol.MethodSymbol method, VisitorState state) {
            if (this.isProtoSubtype(method.owner.type, state)) {
                String methodName = method.name.toString();
                if (NAMED_MUTATOR_METHOD.matcher(methodName).matches()) {
                    return Optional.of(ResultUsePolicy.OPTIONAL);
                }
                if (ProtoRule.isMutatingAccessorMethod(methodName) && this.isProtoSubtype(method.getReturnType(), state)) {
                    return Optional.of(ResultUsePolicy.OPTIONAL);
                }
            }
            return Optional.empty();
        }

        private boolean isProtoSubtype(Type ownerType, VisitorState state) {
            return this.typePredicate.apply(ownerType, state);
        }

        private static boolean isMutatingAccessorMethod(String name) {
            if (name.startsWith("get")) {
                return name.endsWith("Builder") && !name.endsWith("OrBuilder") || name.startsWith("getMutable");
            }
            return false;
        }
    }
}

