/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;

@BugPattern(summary="Methods that always 'return this' should be annotated with @com.google.errorprone.annotations.CanIgnoreReturnValue", severity=BugPattern.SeverityLevel.WARNING)
public final class CanIgnoreReturnValueSuggester
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String CRV = "com.google.errorprone.annotations.CheckReturnValue";
    private static final String CIRV = "com.google.errorprone.annotations.CanIgnoreReturnValue";
    private static final Supplier<Type> PROTO_BUILDER = VisitorState.memoize(s2 -> s2.getTypeFromString("com.google.protobuf.MessageLite.Builder"));
    private static final ImmutableSet<String> BUILDER_METHOD_PREFIXES = ImmutableSet.of("add", "set", "with", "clear");

    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol(methodTree);
        if (methodSymbol.isStatic() || !ASTHelpers.isSameType(methodSymbol.owner.type, methodSymbol.getReturnType(), state) || CanIgnoreReturnValueSuggester.isDefinitionOfZeroArgSelf(methodSymbol) || methodTree.getReturnType() == null || CanIgnoreReturnValueSuggester.isSimpleReturnThisMethod(methodTree) || ASTHelpers.isSubtype(methodSymbol.owner.type, PROTO_BUILDER.get(state), state)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Tree)methodTree, CRV, state) || ASTHelpers.hasAnnotation((Symbol)methodSymbol, CIRV, state)) {
            return Description.NO_MATCH;
        }
        if (CanIgnoreReturnValueSuggester.isAbstractAutoValueOrAutoBuilderMethod(methodSymbol, state)) {
            return Description.NO_MATCH;
        }
        if (CanIgnoreReturnValueSuggester.methodLooksLikeBuilder(methodSymbol) || CanIgnoreReturnValueSuggester.methodReturnsIgnorableValues(methodTree, state)) {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            AnnotationTree riuAnnotation = ASTHelpers.getAnnotationWithSimpleName(methodTree.getModifiers().getAnnotations(), "ResultIgnorabilityUnspecified");
            if (riuAnnotation != null) {
                fix.delete(riuAnnotation);
            }
            fix.prefixWith(methodTree, "@" + SuggestedFixes.qualifyType(state, fix, CIRV) + "\n");
            return this.describeMatch(methodTree, (Fix)fix.build());
        }
        return Description.NO_MATCH;
    }

    private static boolean isAbstractAutoValueOrAutoBuilderMethod(Symbol.MethodSymbol methodSymbol, VisitorState state) {
        Symbol owner = methodSymbol.owner;
        return ASTHelpers.isAbstract(methodSymbol) && (ASTHelpers.hasAnnotation(owner, "com.google.auto.value.AutoValue.Builder", state) || ASTHelpers.hasAnnotation(owner, "com.google.auto.value.AutoBuilder", state));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean methodLooksLikeBuilder(Symbol.MethodSymbol methodSymbol) {
        String methodName = ((Name)methodSymbol.getSimpleName()).toString();
        if (!methodSymbol.owner.getSimpleName().toString().contains("Builder")) return false;
        if (!BUILDER_METHOD_PREFIXES.stream().anyMatch(methodName::startsWith)) return false;
        return true;
    }

    private static boolean isSimpleReturnThisMethod(MethodTree methodTree) {
        StatementTree onlyStatement;
        if (methodTree.getBody() != null && methodTree.getBody().getStatements().size() == 1 && (onlyStatement = methodTree.getBody().getStatements().get(0)) instanceof ReturnTree) {
            return CanIgnoreReturnValueSuggester.returnsThisOrSelf((ReturnTree)onlyStatement);
        }
        return false;
    }

    private static boolean isIdentifier(ExpressionTree expr, String identifierName) {
        if ((expr = ASTHelpers.stripParentheses(expr)) instanceof IdentifierTree) {
            return ((IdentifierTree)expr).getName().contentEquals(identifierName);
        }
        return false;
    }

    private static boolean returnsThisOrSelf(ReturnTree returnTree) {
        return CanIgnoreReturnValueSuggester.maybeCastThis(returnTree.getExpression());
    }

    private static boolean maybeCastThis(Tree tree) {
        return MoreObjects.firstNonNull((Boolean)new SimpleTreeVisitor<Boolean, Void>(){

            @Override
            public Boolean visitParenthesized(ParenthesizedTree tree, Void unused) {
                return (Boolean)this.visit(tree.getExpression(), null);
            }

            @Override
            public Boolean visitTypeCast(TypeCastTree tree, Void unused) {
                return (Boolean)this.visit(tree.getExpression(), null);
            }

            @Override
            public Boolean visitIdentifier(IdentifierTree tree, Void unused) {
                return tree.getName().contentEquals("this");
            }

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                return ((Name)ASTHelpers.getSymbol(tree).getSimpleName()).contentEquals("self") || ((Name)ASTHelpers.getSymbol(tree).getSimpleName()).contentEquals("getThis");
            }
        }.visit(tree, null), false);
    }

    private static boolean isDefinitionOfZeroArgSelf(Symbol.MethodSymbol methodSymbol) {
        return (((Name)methodSymbol.getSimpleName()).contentEquals("self") || ((Name)methodSymbol.getSimpleName()).contentEquals("getThis")) && ((List)methodSymbol.getParameters()).isEmpty();
    }

    private static boolean methodReturnsIgnorableValues(MethodTree tree, VisitorState state) {
        class ReturnValuesFromMethodAreIgnorable
        extends TreeScanner<Void, Void> {
            private final VisitorState state;
            private final Type enclosingClassType;
            private final Type methodReturnType;
            private boolean atLeastOneReturn = false;
            private boolean allReturnsIgnorable = true;

            private ReturnValuesFromMethodAreIgnorable(VisitorState state, Symbol.MethodSymbol methSymbol) {
                this.state = state;
                this.methodReturnType = methSymbol.getReturnType();
                this.enclosingClassType = methSymbol.enclClass().type;
            }

            @Override
            public Void visitReturn(ReturnTree returnTree, Void unused) {
                this.atLeastOneReturn = true;
                if (!CanIgnoreReturnValueSuggester.returnsThisOrSelf(returnTree) && !this.isIgnorableMethodCallOnSameInstance(returnTree, this.state)) {
                    this.allReturnsIgnorable = false;
                }
                return null;
            }

            private boolean isIgnorableMethodCallOnSameInstance(ReturnTree returnTree, VisitorState state) {
                if (returnTree.getExpression() instanceof MethodInvocationTree) {
                    MethodInvocationTree mit = (MethodInvocationTree)returnTree.getExpression();
                    ExpressionTree receiver = ASTHelpers.getReceiver(mit);
                    Symbol.MethodSymbol calledMethod = ASTHelpers.getSymbol(mit);
                    if (receiver == null && !calledMethod.isStatic() || CanIgnoreReturnValueSuggester.isIdentifier(receiver, "this") || CanIgnoreReturnValueSuggester.isIdentifier(receiver, "super")) {
                        return ASTHelpers.hasAnnotation((Symbol)calledMethod, CanIgnoreReturnValueSuggester.CIRV, state) && ASTHelpers.isSubtype(this.enclosingClassType, this.methodReturnType, state) && ASTHelpers.isSubtype(this.enclosingClassType, ASTHelpers.getReturnType(mit), state);
                    }
                }
                return false;
            }

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
                return null;
            }

            @Override
            public Void visitNewClass(NewClassTree node, Void unused) {
                return null;
            }
        }
        ReturnValuesFromMethodAreIgnorable scanner = new ReturnValuesFromMethodAreIgnorable(state, ASTHelpers.getSymbol(tree));
        scanner.scan(tree, null);
        return scanner.atLeastOneReturn && scanner.allReturnsIgnorable;
    }
}

