/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUsePolicy;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUseRule;
import com.google.errorprone.bugpatterns.checkreturnvalue.Rules;
import com.google.errorprone.util.ASTHelpers;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public final class AutoValueRules {
    private AutoValueRules() {
    }

    public static ResultUseRule<VisitorState, Symbol> autoValues() {
        return new ValueRule();
    }

    public static ResultUseRule<VisitorState, Symbol> autoValueBuilders() {
        return new BuilderRule("AutoValue.Builder");
    }

    public static ResultUseRule<VisitorState, Symbol> autoBuilders() {
        return new BuilderRule("AutoBuilder");
    }

    private static abstract class AbstractAutoRule
    extends Rules.ErrorProneMethodRule {
        private static final String PACKAGE = "com.google.auto.value.";
        private final String simpleAnnotation;
        private final String qualifiedAnnotation;

        AbstractAutoRule(String simpleAnnotation) {
            this.simpleAnnotation = simpleAnnotation;
            this.qualifiedAnnotation = PACKAGE + simpleAnnotation;
        }

        @Override
        public String id() {
            return "@" + this.simpleAnnotation;
        }

        protected abstract ResultUsePolicy autoMethodPolicy(Symbol.MethodSymbol var1, Symbol.ClassSymbol var2, VisitorState var3);

        @Override
        public Optional<ResultUsePolicy> evaluateMethod(Symbol.MethodSymbol method, VisitorState state) {
            return Stream.concat(Stream.of(method), ASTHelpers.streamSuperMethods(method, state.getTypes())).filter(m4 -> ASTHelpers.isAbstract(m4) && ASTHelpers.hasAnnotation((Symbol)ASTHelpers.enclosingClass(m4), this.qualifiedAnnotation, state)).findFirst().map(methodSymbol -> this.autoMethodPolicy((Symbol.MethodSymbol)methodSymbol, ASTHelpers.enclosingClass(methodSymbol), state));
        }
    }

    private static final class BuilderRule
    extends AbstractAutoRule {
        BuilderRule(String annotation) {
            super(annotation);
        }

        @Override
        protected ResultUsePolicy autoMethodPolicy(Symbol.MethodSymbol abstractMethod, Symbol.ClassSymbol autoClass, VisitorState state) {
            return ((List)abstractMethod.getParameters()).size() == 1 && ASTHelpers.isSameType(abstractMethod.getReturnType(), autoClass.type, state) ? ResultUsePolicy.OPTIONAL : ResultUsePolicy.EXPECTED;
        }
    }

    private static final class ValueRule
    extends AbstractAutoRule {
        ValueRule() {
            super("AutoValue");
        }

        @Override
        protected ResultUsePolicy autoMethodPolicy(Symbol.MethodSymbol abstractMethod, Symbol.ClassSymbol autoClass, VisitorState state) {
            return ResultUsePolicy.EXPECTED;
        }
    }
}

