/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.bugpatterns.checkreturnvalue.Api;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeMetadata;
import com.sun.tools.javac.code.Types;

public final class ApiFactory {
    private static final Type.StructuralTypeMapping<Void> ANNOTATION_REMOVER = new Type.StructuralTypeMapping<Void>(){

        @Override
        public Type visitType(Type t2, Void unused) {
            return t2.baseType();
        }

        @Override
        public Type visitClassType(Type.ClassType t2, Void unused) {
            return super.visitClassType(t2.cloneWithMetadata(TypeMetadata.EMPTY), unused);
        }

        @Override
        public Type visitArrayType(Type.ArrayType t2, Void unused) {
            return super.visitArrayType(t2.cloneWithMetadata(TypeMetadata.EMPTY), unused);
        }
    };

    public static Api fromSymbol(Symbol.MethodSymbol symbol, Types types) {
        return Api.internalCreate(symbol.owner.getQualifiedName().toString(), symbol.name.toString(), symbol.getParameters().stream().map(p -> ApiFactory.fullyErasedAndUnannotatedType(p.type, types)).collect(ImmutableList.toImmutableList()));
    }

    static String fullyErasedAndUnannotatedType(Type type, Types types) {
        Type erasedType = types.erasureRecursive(type);
        Type unannotatedType = (Type)erasedType.accept(ANNOTATION_REMOVER, null);
        return unannotatedType.toString();
    }

    private ApiFactory() {
    }
}

