/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.checkreturnvalue;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CompileTimeConstant;
import com.google.errorprone.bugpatterns.checkreturnvalue.AutoValue_Api;

@AutoValue
public abstract class Api {
    private static final Joiner COMMA_JOINER = Joiner.on(',');

    public abstract String className();

    public abstract String methodName();

    public abstract ImmutableList<String> parameterTypes();

    public final String toString() {
        return String.format("%s#%s(%s)", this.className(), this.methodName(), COMMA_JOINER.join(this.parameterTypes()));
    }

    boolean isConstructor() {
        return this.methodName().equals("<init>");
    }

    @VisibleForTesting
    public static Api parse(String api) {
        return Api.parse(api, false);
    }

    static Api parseFromStringWithoutWhitespace(String api) {
        return Api.parse(api, true);
    }

    static Api internalCreate(String className, String methodName, ImmutableList<String> params) {
        return new AutoValue_Api(className, methodName, params);
    }

    private static Api parse(String api, boolean assumeNoWhitespace) {
        Parser p = new Parser(api, assumeNoWhitespace);
        String className = p.owningType();
        String methodName = p.methodName();
        ImmutableList<String> paramList = p.parameters();
        p.ensureNoMoreCharacters();
        return Api.internalCreate(className, methodName, paramList);
    }

    private static final class Parser {
        private final String api;
        private final boolean assumeNoWhitespace;
        private int position = -1;

        Parser(String api, boolean assumeNoWhitespace) {
            this.api = api;
            this.assumeNoWhitespace = assumeNoWhitespace;
        }

        String owningType() {
            StringBuilder buffer = new StringBuilder(this.api.length());
            block5: while (true) {
                char next = this.nextLookingFor('#');
                switch (next) {
                    case '#': {
                        break block5;
                    }
                    case '.': {
                        break;
                    }
                    case '-': {
                        break;
                    }
                    default: {
                        Preconditions.checkArgument(Character.isJavaIdentifierPart(next), "Unable to parse '%s' because '%s' is not a valid identifier", (Object)this.api, next);
                    }
                }
                buffer.append(next);
            }
            String type = buffer.toString();
            Parser.check(!type.isEmpty(), this.api, "class name cannot be empty");
            Parser.check(Character.isJavaIdentifierStart(type.charAt(0)), this.api, "the class name must start with a valid character");
            return type;
        }

        String methodName() {
            StringBuilder buffer = new StringBuilder(this.api.length() - this.position);
            boolean isConstructor = false;
            boolean finishedConstructor = false;
            block5: while (true) {
                char next = this.nextLookingFor('(');
                switch (next) {
                    case '(': {
                        break block5;
                    }
                    case '<': {
                        Parser.check(!isConstructor, this.api, "Only one '<' is allowed");
                        Parser.check(buffer.length() == 0, this.api, "'<' must come directly after '#'");
                        isConstructor = true;
                        break;
                    }
                    case '>': {
                        Parser.check(isConstructor, this.api, "'<' must come before '>'");
                        Parser.check(!finishedConstructor, this.api, "Only one '>' is allowed");
                        finishedConstructor = true;
                        break;
                    }
                    default: {
                        Preconditions.checkArgument(Character.isJavaIdentifierPart(next), "Unable to parse '%s' because '%s' is not a valid identifier", (Object)this.api, next);
                    }
                }
                buffer.append(next);
            }
            String methodName = buffer.toString();
            if (isConstructor) {
                Parser.check(finishedConstructor, this.api, "found '<' without closing '>");
                Preconditions.checkArgument(methodName.equals("<init>"), "Unable to parse '%s' because %s is an invalid method name", (Object)this.api, (Object)methodName);
            } else {
                Parser.check(!methodName.isEmpty(), this.api, "method name cannot be empty");
                Parser.check(Character.isJavaIdentifierStart(methodName.charAt(0)), this.api, "the method name must start with a valid character");
            }
            return methodName;
        }

        ImmutableList<String> parameters() {
            StringBuilder buffer = new StringBuilder(this.api.length() - this.position);
            ImmutableList.Builder paramBuilder = ImmutableList.builder();
            boolean emptyList = true;
            block5: while (true) {
                char next = this.nextLookingFor(')');
                switch (next) {
                    case ')': {
                        if (emptyList) {
                            return ImmutableList.of();
                        }
                        paramBuilder.add(this.consumeParam(buffer));
                        break block5;
                    }
                    case ',': {
                        paramBuilder.add(this.consumeParam(buffer));
                        continue block5;
                    }
                    case '.': 
                    case '[': 
                    case ']': {
                        buffer.append(next);
                        continue block5;
                    }
                    default: {
                        Preconditions.checkArgument(Character.isJavaIdentifierPart(next), "Unable to parse '%s' because '%s' is not a valid identifier", (Object)this.api, next);
                        emptyList = false;
                        buffer.append(next);
                        continue block5;
                    }
                }
                break;
            }
            return paramBuilder.build();
        }

        private String consumeParam(StringBuilder buffer) {
            String parameter = buffer.toString();
            buffer.setLength(0);
            Parser.check(!parameter.isEmpty(), this.api, "parameters cannot be empty");
            Parser.check(Character.isJavaIdentifierStart(parameter.charAt(0)), this.api, "parameters must start with a valid character");
            boolean parsingArrayStart = false;
            boolean hasArraySpecifiers = false;
            block4: for (int k = 1; k < parameter.length(); ++k) {
                char c = parameter.charAt(k);
                switch (c) {
                    case '[': {
                        Parser.check(!parsingArrayStart, this.api, "multiple consecutive [");
                        hasArraySpecifiers = true;
                        parsingArrayStart = true;
                        continue block4;
                    }
                    case ']': {
                        Parser.check(parsingArrayStart, this.api, "unbalanced ] in array type");
                        parsingArrayStart = false;
                        continue block4;
                    }
                    default: {
                        Parser.check(!hasArraySpecifiers, this.api, "types with array specifiers should end in those specifiers");
                    }
                }
            }
            Parser.check(!parsingArrayStart, this.api, "[ without closing ] at the end of a parameter type");
            return parameter;
        }

        private char nextLookingFor(char delimiter) {
            char next;
            do {
                ++this.position;
                Preconditions.checkArgument(this.position < this.api.length(), "Could not parse '%s' as it must contain an '%s'", (Object)this.api, delimiter);
                next = this.api.charAt(this.position);
            } while (!this.assumeNoWhitespace && CharMatcher.whitespace().matches(next));
            return next;
        }

        void ensureNoMoreCharacters() {
            if (this.assumeNoWhitespace) {
                return;
            }
            while (++this.position < this.api.length()) {
                Parser.check(CharMatcher.whitespace().matches(this.api.charAt(this.position)), this.api, "it should end in ')'");
            }
        }

        private static void check(boolean condition, String api, @CompileTimeConstant String reason) {
            Preconditions.checkArgument(condition, "Unable to parse '%s' because %s", (Object)api, (Object)reason);
        }
    }
}

