/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.android;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Detects classes which implement Parcelable but don't have CREATOR", severity=BugPattern.SeverityLevel.ERROR)
public class ParcelableCreator
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ClassTree> PARCELABLE_MATCHER = Matchers.allOf(Matchers.isDirectImplementationOf("android.os.Parcelable"), Matchers.not(Matchers.hasModifier(Modifier.ABSTRACT)));
    private static final Matcher<VariableTree> PARCELABLE_CREATOR_MATCHER = Matchers.allOf(Matchers.isSubtypeOf("android.os.Parcelable$Creator"), Matchers.hasModifier(Modifier.STATIC), Matchers.hasModifier(Modifier.PUBLIC));
    private static final Supplier<Symbol> ANDROID_OS_PARCELABLE_CREATOR = VisitorState.memoize(state -> state.getSymbolFromString("android.os.Parcelable$Creator"));

    @Override
    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!state.isAndroidCompatible()) {
            return Description.NO_MATCH;
        }
        if (!PARCELABLE_MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        Symbol parcelableCreatorSymbol = ANDROID_OS_PARCELABLE_CREATOR.get(state);
        if (parcelableCreatorSymbol == null) {
            return Description.NO_MATCH;
        }
        Type.ClassType classType = ASTHelpers.getType(tree);
        for (Tree tree2 : tree.getMembers()) {
            VariableTree variableTree;
            if (tree2.getKind() != Tree.Kind.VARIABLE || !PARCELABLE_CREATOR_MATCHER.matches(variableTree = (VariableTree)tree2, state) || !ParcelableCreator.isVariableClassCreator(variableTree, state, classType, parcelableCreatorSymbol)) continue;
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }

    private static boolean isVariableClassCreator(VariableTree variableTree, VisitorState state, Type.ClassType classType, Symbol parcelableCreatorSymbol) {
        Tree typeTree = variableTree.getType();
        Type type = ASTHelpers.getType(typeTree);
        Types types = state.getTypes();
        Type superType = types.asSuper(type, parcelableCreatorSymbol);
        if (superType == null) {
            return false;
        }
        List<Type> typeArguments = superType.getTypeArguments();
        if (typeArguments.isEmpty()) {
            return true;
        }
        return ASTHelpers.isSubtype(classType, Iterables.getOnlyElement(typeArguments), state);
    }
}

