/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.Objects;

@BugPattern(summary="The non-constant portion of an equals check generally comes first.", severity=BugPattern.SeverityLevel.WARNING)
public final class YodaCondition
extends BugChecker
implements BugChecker.BinaryTreeMatcher,
BugChecker.MethodInvocationTreeMatcher {
    @Override
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        switch (tree.getKind()) {
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                return this.fix(tree, tree.getLeftOperand(), tree.getRightOperand(), false, state);
            }
        }
        return Description.NO_MATCH;
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (Matchers.staticEqualsInvocation().matches(tree, state)) {
            return this.fix(tree, tree.getArguments().get(0), tree.getArguments().get(1), false, state);
        }
        if (Matchers.instanceEqualsInvocation().matches(tree, state)) {
            return this.fix(tree, ASTHelpers.getReceiver(tree), tree.getArguments().get(0), true, state);
        }
        return Description.NO_MATCH;
    }

    private Description fix(Tree tree, Tree lhs, Tree rhs, boolean provideNullSafeFix, VisitorState state) {
        if (YodaCondition.seemsConstant(lhs) && !YodaCondition.seemsConstant(rhs)) {
            Description.Builder description = this.buildDescription(lhs).addFix(SuggestedFix.swap(lhs, rhs));
            if (provideNullSafeFix) {
                SuggestedFix.Builder fix = SuggestedFix.builder().setShortDescription("null-safe fix");
                description.addFix(fix.replace(tree, String.format("%s.equals(%s, %s)", SuggestedFixes.qualifyType(state, fix, Objects.class.getName()), state.getSourceForNode(rhs), state.getSourceForNode(lhs))).build());
            }
            return description.build();
        }
        return Description.NO_MATCH;
    }

    private static boolean seemsConstant(Tree tree) {
        if (ASTHelpers.constValue(tree) != null) {
            return true;
        }
        Symbol symbol = ASTHelpers.getSymbol(tree);
        return symbol instanceof Symbol.VarSymbol && symbol.isEnum();
    }
}

