/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_WildcardImport_TypeToImport;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="Wildcard imports, static or otherwise, should not be used", severity=BugPattern.SeverityLevel.SUGGESTION, linkType=BugPattern.LinkType.CUSTOM, documentSuppression=false, tags={"Style"}, link="https://google.github.io/styleguide/javaguide.html?cl=head#s3.3.1-wildcard-imports")
public class WildcardImport
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Logger logger;
    public static final int MAX_MEMBER_IMPORTS = 20;
    private static final MethodHandle CONSTANT_CASE_LABEL_TREE_GET_EXPRESSION;

    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        ImmutableList<ImportTree> wildcardImports = WildcardImport.getWildcardImports(tree.getImports());
        if (wildcardImports.isEmpty()) {
            return Description.NO_MATCH;
        }
        Set<TypeToImport> typesToImport = ImportCollector.collect((JCTree.JCCompilationUnit)tree);
        Fix fix = WildcardImport.createFix(wildcardImports, typesToImport, state);
        if (fix.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch((Tree)wildcardImports.get(0), fix);
    }

    private static ImmutableList<ImportTree> getWildcardImports(List<? extends ImportTree> imports) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (ImportTree importTree : imports) {
            MemberSelectTree select;
            Tree ident = importTree.getQualifiedIdentifier();
            if (!(ident instanceof MemberSelectTree) || !(select = (MemberSelectTree)ident).getIdentifier().contentEquals("*")) continue;
            result.add(importTree);
        }
        return result.build();
    }

    static Fix createFix(ImmutableList<ImportTree> wildcardImports, Set<TypeToImport> typesToImport, VisitorState state) {
        Map<Symbol, List<TypeToImport>> toFix = typesToImport.stream().collect(Collectors.groupingBy(TypeToImport::owner));
        SuggestedFix.Builder fix = SuggestedFix.builder();
        for (ImportTree importToDelete : wildcardImports) {
            String importSpecification = state.getSourceForNode(importToDelete.getQualifiedIdentifier());
            if (importToDelete.isStatic()) {
                fix.removeStaticImport(importSpecification);
                continue;
            }
            fix.removeImport(importSpecification);
        }
        for (Map.Entry<Symbol, List<TypeToImport>> entry : toFix.entrySet()) {
            Symbol owner = entry.getKey();
            if (entry.getKey().getKind() != ElementKind.PACKAGE && entry.getValue().size() > 20) {
                WildcardImport.qualifiedNameFix(fix, owner, state);
                continue;
            }
            for (TypeToImport toImport : entry.getValue()) {
                toImport.addFix(fix);
            }
        }
        return fix.build();
    }

    private static void qualifiedNameFix(final SuggestedFix.Builder fix, final Symbol owner, VisitorState state) {
        fix.addImport(owner.getQualifiedName().toString());
        final JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)state.getPath().getCompilationUnit();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                Symbol sym = ASTHelpers.getSymbol(tree);
                if (sym == null) {
                    return null;
                }
                Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                if (sym.owner.getKind() == ElementKind.ENUM) {
                    if (parent.getKind() == Tree.Kind.CASE && ((CaseTree)parent).getExpression().equals(tree)) {
                        return null;
                    }
                    if (parent.getKind().name().equals("CONSTANT_CASE_LABEL")) {
                        try {
                            if (tree.equals(CONSTANT_CASE_LABEL_TREE_GET_EXPRESSION.invoke(parent))) {
                                return null;
                            }
                        }
                        catch (Throwable e) {
                            logger.log(Level.SEVERE, "Could not compare trees", e);
                        }
                    }
                }
                if (sym.owner.equals(owner) && unit.starImportScope.includes(sym)) {
                    fix.prefixWith(tree, owner.getSimpleName() + ".");
                }
                return null;
            }
        }.scan(unit, null);
    }

    static {
        MethodHandle h2;
        logger = Logger.getLogger(WildcardImport.class.getName());
        try {
            Class<?> constantCaseLabelTree = Class.forName("com.sun.source.tree.ConstantCaseLabelTree");
            h2 = MethodHandles.lookup().findVirtual(constantCaseLabelTree, "getConstantExpression", MethodType.methodType(ExpressionTree.class));
        }
        catch (ReflectiveOperationException e) {
            h2 = null;
        }
        CONSTANT_CASE_LABEL_TREE_GET_EXPRESSION = h2;
    }

    static class ImportCollector
    extends TreeScanner {
        private final Scope.StarImportScope wildcardScope;
        private final Set<TypeToImport> seen = new LinkedHashSet<TypeToImport>();

        ImportCollector(Scope.StarImportScope wildcardScope) {
            this.wildcardScope = wildcardScope;
        }

        public static Set<TypeToImport> collect(JCTree.JCCompilationUnit tree) {
            ImportCollector collector = new ImportCollector(tree.starImportScope);
            collector.scan(tree);
            return collector.seen;
        }

        @Override
        public void visitImport(JCTree.JCImport tree) {
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl method) {
            if (ASTHelpers.isGeneratedConstructor(method)) {
                this.scan(method.body);
            } else {
                super.visitMethodDef(method);
            }
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            Symbol sym = tree.sym;
            if (sym == null) {
                return;
            }
            if (this.wildcardScope.includes(sym = sym.baseSymbol())) {
                if (sym.owner.getQualifiedName().contentEquals("java.lang")) {
                    return;
                }
                switch (sym.kind) {
                    case TYP: {
                        this.seen.add(TypeToImport.create(sym.getSimpleName().toString(), sym.owner, false));
                        break;
                    }
                    case VAR: 
                    case MTH: {
                        this.seen.add(TypeToImport.create(sym.getSimpleName().toString(), sym.owner, true));
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        }
    }

    @AutoValue
    static abstract class TypeToImport {
        TypeToImport() {
        }

        abstract String name();

        abstract Symbol owner();

        abstract boolean isStatic();

        static TypeToImport create(String name, Symbol owner, boolean stat) {
            return new AutoValue_WildcardImport_TypeToImport(name, owner, stat);
        }

        private void addFix(SuggestedFix.Builder fix) {
            String qualifiedName = this.owner().getQualifiedName() + "." + this.name();
            if (this.isStatic()) {
                fix.addStaticImport(qualifiedName);
            } else {
                fix.addImport(qualifiedName);
            }
        }
    }
}

