/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractUseSwitch;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.ElementKind;
import org.checkerframework.checker.nullness.qual.Nullable;

@BugPattern(summary="Prefer using a switch instead of a chained if-else for enums", severity=BugPattern.SeverityLevel.SUGGESTION)
public class UseEnumSwitch
extends AbstractUseSwitch {
    @Override
    protected @Nullable String getExpressionForCase(VisitorState state, ExpressionTree argument) {
        Symbol sym = ASTHelpers.getSymbol(argument);
        return sym != null && sym.getKind().equals((Object)ElementKind.ENUM_CONSTANT) ? sym.getSimpleName().toString() : null;
    }
}

