/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(altNames={"Unused", "unused", "UnusedParameters"}, summary="Unused.", severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false)
public final class UnusedMethod
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final String GWT_JAVASCRIPT_OBJECT = "com.google.gwt.core.client.JavaScriptObject";
    private static final String EXEMPT_PREFIX = "unused";
    private static final String JUNIT_PARAMS_VALUE = "value";
    private static final String JUNIT_PARAMS_ANNOTATION_TYPE = "junitparams.Parameters";
    private static final ImmutableSet<String> EXEMPTING_METHOD_ANNOTATIONS = ImmutableSet.of("com.fasterxml.jackson.annotation.JsonCreator", "com.fasterxml.jackson.annotation.JsonValue", "com.google.acai.AfterTest", "com.google.acai.BeforeSuite", "com.google.acai.BeforeTest", "com.google.caliper.Benchmark", new String[]{"com.google.common.eventbus.Subscribe", "com.google.inject.Provides", "com.google.inject.Inject", "com.google.inject.multibindings.ProvidesIntoMap", "com.google.inject.multibindings.ProvidesIntoSet", "com.google.inject.throwingproviders.CheckedProvides", "com.tngtech.java.junit.dataprovider.DataProvider", "jakarta.annotation.PreDestroy", "jakarta.annotation.PostConstruct", "jakarta.inject.Inject", "jakarta.persistence.PostLoad", "jakarta.persistence.PostPersist", "jakarta.persistence.PostRemove", "jakarta.persistence.PostUpdate", "jakarta.persistence.PrePersist", "jakarta.persistence.PreRemove", "jakarta.persistence.PreUpdate", "javax.annotation.PreDestroy", "javax.annotation.PostConstruct", "javax.inject.Inject", "javax.persistence.PostLoad", "javax.persistence.PostPersist", "javax.persistence.PostRemove", "javax.persistence.PostUpdate", "javax.persistence.PrePersist", "javax.persistence.PreRemove", "javax.persistence.PreUpdate", "org.apache.beam.sdk.transforms.DoFn.ProcessElement", "org.aspectj.lang.annotation.Pointcut", "org.aspectj.lang.annotation.After", "org.aspectj.lang.annotation.Before", "org.springframework.context.annotation.Bean", "org.testng.annotations.AfterClass", "org.testng.annotations.AfterMethod", "org.testng.annotations.BeforeClass", "org.testng.annotations.BeforeMethod", "org.testng.annotations.DataProvider", "org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll", "org.junit.jupiter.api.AfterEach", "org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.RepeatedTest", "org.junit.jupiter.api.Test", "org.junit.jupiter.params.ParameterizedTest"});
    private static final ImmutableSet<String> EXEMPTING_SUPER_TYPES = ImmutableSet.of();
    private final ImmutableSet<String> additionalExemptingMethodAnnotations;
    private static final Supplier<Name> ORG_JUNIT_JUPITER_PARAMS_PROVIDER_METHODSOURCE = VisitorState.memoize(state -> state.getName("org.junit.jupiter.params.provider.MethodSource"));

    public UnusedMethod(ErrorProneFlags errorProneFlags) {
        this.additionalExemptingMethodAnnotations = errorProneFlags.getList("UnusedMethod:ExemptingMethodAnnotations").map(ImmutableSet::copyOf).orElseGet(ImmutableSet::of);
    }

    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        final HashMap unusedMethods = new HashMap();
        if (UnusedMethod.hasNativeMethods(tree)) {
            return Description.NO_MATCH;
        }
        final AtomicBoolean ignoreUnusedMethods = new AtomicBoolean(false);
        final ImmutableSet<Symbol.ClassSymbol> classesMadeVisible = this.getVisibleClasses(tree);
        class MethodFinder
        extends BugChecker.SuppressibleTreePathScanner<Void, Void> {
            MethodFinder(VisitorState state) {
                super(state);
            }

            @Override
            public Void visitClass(ClassTree tree, Void unused) {
                if (this.exemptedBySuperType(ASTHelpers.getType(tree), this.state)) {
                    return null;
                }
                return (Void)super.visitClass(tree, null);
            }

            private boolean exemptedBySuperType(Type type, VisitorState state) {
                return EXEMPTING_SUPER_TYPES.stream().anyMatch(t2 -> ASTHelpers.isSubtype(type, Suppliers.typeFromString(t2).get(state), state));
            }

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                if (this.hasJUnitParamsParametersForMethodAnnotation(tree.getModifiers().getAnnotations())) {
                    ignoreUnusedMethods.set(true);
                }
                if (this.isMethodSymbolEligibleForChecking(tree, classesMadeVisible)) {
                    unusedMethods.put(ASTHelpers.getSymbol(tree), this.getCurrentPath());
                }
                return (Void)super.visitMethod(tree, unused);
            }

            private boolean hasJUnitParamsParametersForMethodAnnotation(Collection<? extends AnnotationTree> annotations) {
                for (AnnotationTree annotationTree : annotations) {
                    JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)annotationTree;
                    if (annotation.getAnnotationType().type == null || !annotation.getAnnotationType().type.toString().equals(UnusedMethod.JUNIT_PARAMS_ANNOTATION_TYPE)) continue;
                    if (((List)annotation.getArguments()).isEmpty()) {
                        return true;
                    }
                    for (JCTree.JCExpression arg : annotation.getArguments()) {
                        if (arg.getKind() != Tree.Kind.ASSIGNMENT) {
                            return false;
                        }
                        JCTree.JCExpression var = ((JCTree.JCAssign)arg).getVariable();
                        if (var.getKind() != Tree.Kind.IDENTIFIER || ((IdentifierTree)((Object)var)).getName().contentEquals(UnusedMethod.JUNIT_PARAMS_VALUE)) continue;
                        return true;
                    }
                }
                return false;
            }

            private boolean isMethodSymbolEligibleForChecking(MethodTree tree, Set<Symbol.ClassSymbol> classesMadeVisible2) {
                Type lastParamType;
                if (UnusedMethod.exemptedByName(tree.getName())) {
                    return false;
                }
                if (UnusedMethod.this.exemptedByAnnotation(tree.getModifiers().getAnnotations())) {
                    return false;
                }
                if (ASTHelpers.shouldKeep(tree)) {
                    return false;
                }
                Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol(tree);
                if (!ASTHelpers.canBeRemoved(methodSymbol, this.state)) {
                    return false;
                }
                if (this.isExemptedConstructor(methodSymbol, this.state) || ASTHelpers.isGeneratedConstructor(tree) || Matchers.SERIALIZATION_METHODS.matches(tree, this.state)) {
                    return false;
                }
                if (!tree.getParameters().isEmpty() && (lastParamType = ASTHelpers.getType(Iterables.getLast(tree.getParameters()))) != null && lastParamType.toString().equals(UnusedMethod.GWT_JAVASCRIPT_OBJECT)) {
                    return false;
                }
                return methodSymbol.isPrivate() || !classesMadeVisible2.stream().anyMatch(t2 -> ASTHelpers.isSubtype(t2.type, methodSymbol.owner.type, this.state));
            }

            private boolean isExemptedConstructor(Symbol.MethodSymbol methodSymbol, VisitorState state) {
                if (!methodSymbol.getKind().equals((Object)ElementKind.CONSTRUCTOR)) {
                    return false;
                }
                return methodSymbol.params().isEmpty();
            }
        }
        new MethodFinder(state).scan(state.getPath(), null);
        class FilterUsedMethods
        extends TreePathScanner<Void, Void> {
            FilterUsedMethods() {
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
                Symbol symbol = ASTHelpers.getSymbol(memberSelectTree);
                unusedMethods.remove(symbol);
                return (Void)super.visitMemberSelect(memberSelectTree, null);
            }

            @Override
            public Void visitMemberReference(MemberReferenceTree tree, Void unused) {
                super.visitMemberReference(tree, null);
                Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(tree);
                unusedMethods.remove(symbol);
                symbol.getParameters().forEach(unusedMethods::remove);
                return null;
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                this.handle(ASTHelpers.getSymbol(tree));
                return (Void)super.visitMethodInvocation(tree, null);
            }

            @Override
            public Void visitNewClass(NewClassTree tree, Void unused) {
                this.handle(ASTHelpers.getSymbol(tree));
                return (Void)super.visitNewClass(tree, null);
            }

            @Override
            public Void visitAssignment(AssignmentTree tree, Void unused) {
                this.handle(ASTHelpers.getSymbol(tree.getVariable()));
                return (Void)super.visitAssignment(tree, unused);
            }

            private void handle(Symbol symbol) {
                if (symbol instanceof Symbol.MethodSymbol) {
                    unusedMethods.remove(symbol);
                }
            }

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                this.handleMethodSource(tree);
                return (Void)super.visitMethod(tree, null);
            }

            private void handleMethodSource(MethodTree tree) {
                Symbol.MethodSymbol sym = ASTHelpers.getSymbol(tree);
                javax.lang.model.element.Name name = ORG_JUNIT_JUPITER_PARAMS_PROVIDER_METHODSOURCE.get(state);
                sym.getRawAttributes().stream().filter(a -> a.type.tsym.getQualifiedName().equals(name)).findAny().flatMap(a -> MoreAnnotations.getAnnotationValue(a, UnusedMethod.JUNIT_PARAMS_VALUE)).map(y -> MoreAnnotations.asStrings(y).map(state::getName).map(Object::toString).collect(ImmutableSet.toImmutableSet())).ifPresent(referencedNames -> unusedMethods.entrySet().removeIf(e -> {
                    Symbol unusedSym = (Symbol)e.getKey();
                    String simpleName = unusedSym.getSimpleName().toString();
                    return referencedNames.contains(simpleName) || referencedNames.contains(unusedSym.owner.getQualifiedName() + "#" + simpleName);
                }));
            }
        }
        new FilterUsedMethods().scan(state.getPath(), null);
        if (ignoreUnusedMethods.get()) {
            return Description.NO_MATCH;
        }
        this.fixNonConstructors(unusedMethods.values().stream().filter(t2 -> !ASTHelpers.getSymbol(t2.getLeaf()).isConstructor()).collect(ImmutableList.toImmutableList()), state);
        ImmutableListMultimap<Symbol, TreePath> unusedConstructors = unusedMethods.values().stream().filter(t2 -> ASTHelpers.getSymbol(t2.getLeaf()).isConstructor()).collect(ImmutableListMultimap.toImmutableListMultimap(t2 -> ASTHelpers.getSymbol((Tree)t2.getLeaf()).owner, t2 -> t2));
        this.fixConstructors(unusedConstructors, state);
        return Description.NO_MATCH;
    }

    private ImmutableSet<Symbol.ClassSymbol> getVisibleClasses(CompilationUnitTree tree) {
        final ImmutableSet.Builder classesMadeVisible = ImmutableSet.builder();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitClass(ClassTree tree, Void unused) {
                Symbol.ClassSymbol symbol = ASTHelpers.getSymbol(tree);
                if (!ASTHelpers.canBeRemoved(symbol)) {
                    classesMadeVisible.add(symbol);
                }
                return (Void)super.visitClass(tree, null);
            }
        }.scan(tree, null);
        return classesMadeVisible.build();
    }

    private void fixNonConstructors(Iterable<TreePath> unusedPaths, VisitorState state) {
        for (TreePath unusedPath : unusedPaths) {
            Tree unusedTree = unusedPath.getLeaf();
            Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)unusedTree);
            String message = String.format("Method '%s' is never used.", symbol.getSimpleName());
            state.reportMatch(this.buildDescription(unusedTree).addFix(SuggestedFixes.replaceIncludingComments(unusedPath, "", state)).setMessage(message).build());
        }
    }

    private void fixConstructors(ImmutableListMultimap<Symbol, TreePath> unusedConstructors, VisitorState state) {
        for (Map.Entry<Symbol, java.util.List<TreePath>> entry : Multimaps.asMap(unusedConstructors).entrySet()) {
            boolean fixable;
            Symbol symbol = entry.getKey();
            java.util.List<TreePath> trees = entry.getValue();
            SuggestedFix.Builder fix = SuggestedFix.builder();
            int constructorCount = Iterables.size(ASTHelpers.scope(symbol.members()).getSymbols(Symbol::isConstructor));
            int finalFields = Iterables.size(ASTHelpers.scope(symbol.members()).getSymbols(s2 -> s2.getKind().equals((Object)ElementKind.FIELD) && s2.getModifiers().contains((Object)Modifier.FINAL)));
            if (constructorCount == trees.size()) {
                fix.postfixWith(Iterables.getLast(trees).getLeaf(), String.format("private %s() {}", symbol.getSimpleName()));
                fixable = finalFields == 0;
            } else {
                fixable = true;
            }
            String message = String.format("Constructor '%s' is never used.", symbol.getSimpleName());
            trees.forEach(t2 -> fix.merge(SuggestedFixes.replaceIncludingComments(t2, "", state)));
            state.reportMatch(this.buildDescription(trees.get(0).getLeaf()).addFix(fixable ? fix.build() : SuggestedFix.emptyFix()).setMessage(message).build());
        }
    }

    private static boolean hasNativeMethods(CompilationUnitTree tree) {
        final AtomicBoolean hasAnyNativeMethods = new AtomicBoolean(false);
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                if (tree.getModifiers().getFlags().contains((Object)Modifier.NATIVE)) {
                    hasAnyNativeMethods.set(true);
                }
                return null;
            }
        }.scan(tree, null);
        return hasAnyNativeMethods.get();
    }

    private boolean exemptedByAnnotation(java.util.List<? extends AnnotationTree> annotations) {
        for (AnnotationTree annotationTree : annotations) {
            Symbol.TypeSymbol tsym;
            String annotationName;
            Type annotationType = ASTHelpers.getType(annotationTree);
            if (annotationType == null || !EXEMPTING_METHOD_ANNOTATIONS.contains(annotationName = (tsym = annotationType.tsym).getQualifiedName().toString()) && !this.additionalExemptingMethodAnnotations.contains(annotationName)) continue;
            return true;
        }
        return false;
    }

    private static boolean exemptedByName(javax.lang.model.element.Name name) {
        return Ascii.toLowerCase(name.toString()).startsWith(EXEMPT_PREFIX);
    }
}

