/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.util.TreeScanner;
import java.util.HashMap;

@BugPattern(summary="This label is unused.", severity=BugPattern.SeverityLevel.WARNING)
public final class UnusedLabel
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        final HashMap labels = new HashMap();
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(state){

            @Override
            public Void visitLabeledStatement(LabeledStatementTree tree, Void unused) {
                labels.put(tree.getLabel(), tree);
                return (Void)super.visitLabeledStatement(tree, null);
            }
        }.scan(state.getPath(), null);
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitBreak(BreakTree tree, Void unused) {
                labels.remove(tree.getLabel());
                return (Void)super.visitBreak(tree, null);
            }

            @Override
            public Void visitContinue(ContinueTree tree, Void unused) {
                labels.remove(tree.getLabel());
                return (Void)super.visitContinue(tree, null);
            }
        }.scan(tree, null);
        for (LabeledStatementTree label : labels.values()) {
            state.reportMatch(this.describeMatch(label, (Fix)SuggestedFix.replace(ASTHelpers.getStartPosition(label), ASTHelpers.getStartPosition(label.getStatement()), "")));
        }
        return Description.NO_MATCH;
    }
}

