/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Name;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

@BugPattern(summary="This catch block catches an exception and re-throws another, but swallows the caught exception rather than setting it as a cause. This can make debugging harder.", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"}, documentSuppression=false)
public final class UnusedException
extends BugChecker
implements BugChecker.CatchTreeMatcher {
    private static final ImmutableSet<Modifier> VISIBILITY_MODIFIERS = ImmutableSet.of(Modifier.PRIVATE, Modifier.PROTECTED, Modifier.PUBLIC);
    private static final Supplier<Type> JAVA_IO_INTERRUPTEDIOEXCEPTION = VisitorState.memoize(state -> state.getTypeFromString("java.io.InterruptedIOException"));

    @Override
    public Description matchCatch(CatchTree tree, VisitorState state) {
        if (this.isSuppressed(tree.getParameter(), state) || UnusedException.isSuppressedViaName(tree.getParameter())) {
            return Description.NO_MATCH;
        }
        final Symbol.VarSymbol exceptionSymbol = ASTHelpers.getSymbol(tree.getParameter());
        TypeMirror exceptionType = exceptionSymbol.asType();
        if (ASTHelpers.isSameType((Type)exceptionType, state.getSymtab().interruptedExceptionType, state) || ASTHelpers.isSameType((Type)exceptionType, JAVA_IO_INTERRUPTEDIOEXCEPTION.get(state), state)) {
            return Description.NO_MATCH;
        }
        final AtomicBoolean symbolUsed = new AtomicBoolean(false);
        ((JCTree)((Object)tree)).accept(new TreeScanner(){

            @Override
            public void visitIdent(JCTree.JCIdent identTree) {
                if (exceptionSymbol.equals(identTree.sym)) {
                    symbolUsed.set(true);
                }
            }
        });
        if (symbolUsed.get()) {
            return Description.NO_MATCH;
        }
        final HashSet throwTrees = new HashSet();
        ((JCTree)((Object)tree)).accept(new TreeScanner(){

            @Override
            public void visitThrow(JCTree.JCThrow throwTree) {
                super.visitThrow(throwTree);
                throwTrees.add(throwTree);
            }

            @Override
            public void visitTry(JCTree.JCTry tryTree) {
            }
        });
        if (throwTrees.isEmpty()) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder allFixes = SuggestedFix.builder();
        throwTrees.stream().filter(badThrow -> badThrow.getExpression() instanceof NewClassTree).forEach(badThrow -> UnusedException.fixConstructor((NewClassTree)((Object)badThrow.getExpression()), exceptionSymbol, state).ifPresent(allFixes::merge));
        return this.describeMatch(tree, (Fix)allFixes.build());
    }

    private static boolean isSuppressedViaName(VariableTree parameter) {
        return parameter.getName().toString().startsWith("unused");
    }

    private static Optional<SuggestedFix> fixConstructor(NewClassTree constructor, Symbol.VarSymbol exception, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol(((JCTree.JCNewClass)constructor).clazz);
        if (!(symbol instanceof Symbol.ClassSymbol)) {
            return Optional.empty();
        }
        ImmutableList<Symbol.MethodSymbol> constructors = ASTHelpers.getConstructors((Symbol.ClassSymbol)symbol);
        Symbol.MethodSymbol constructorSymbol = ASTHelpers.getSymbol(constructor);
        List<Type> types = UnusedException.getParameterTypes(constructorSymbol);
        for (Symbol.MethodSymbol proposedConstructor : constructors) {
            List<Type> proposedTypes = UnusedException.getParameterTypes(proposedConstructor);
            if (proposedTypes.size() != types.size() + 1) continue;
            Sets.SetView<Modifier> constructorVisibility = Sets.intersection(constructorSymbol.getModifiers(), VISIBILITY_MODIFIERS);
            Sets.SetView<Modifier> replacementVisibility = Sets.intersection(proposedConstructor.getModifiers(), VISIBILITY_MODIFIERS);
            if (constructor.getClassBody() == null && !constructorVisibility.equals(replacementVisibility) || !UnusedException.typesEqual(proposedTypes.subList(0, types.size()), types, state) || !state.getTypes().isAssignable(exception.type, Iterables.getLast(proposedTypes))) continue;
            return Optional.of(UnusedException.appendArgument(constructor, ((Name)exception.getSimpleName()).toString(), state, types));
        }
        return Optional.empty();
    }

    private static boolean typesEqual(List<Type> typesA, List<Type> typesB, VisitorState state) {
        return Streams.zip(typesA.stream(), typesB.stream(), (a, b) -> ASTHelpers.isSameType(a, b, state)).allMatch(x -> x);
    }

    private static SuggestedFix appendArgument(NewClassTree constructor, String exception, VisitorState state, List<Type> types) {
        if (types.isEmpty()) {
            String source = state.getSourceForNode(constructor);
            int startPosition = ASTHelpers.getStartPosition(constructor);
            int pos = source.indexOf(40, state.getEndPosition(constructor.getIdentifier()) - startPosition) + startPosition + 1;
            return SuggestedFix.replace(pos, pos, exception);
        }
        return SuggestedFix.postfixWith(Iterables.getLast(constructor.getArguments()), String.format(", %s", exception));
    }

    private static List<Type> getParameterTypes(Symbol.MethodSymbol constructorSymbol) {
        return constructorSymbol.type.getParameterTypes();
    }
}

