/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(summary="Instance created but never used", severity=BugPattern.SeverityLevel.ERROR)
public class UnusedAnonymousClass
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final ImmutableList<String> TYPES_WITH_SIDE_EFFECT_FREE_CONSTRUCTORS = ImmutableList.of(Thread.class.getName());

    @Override
    public Description matchNewClass(NewClassTree newClassTree, VisitorState state) {
        if (state.getPath().getParentPath().getLeaf().getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
            return Description.NO_MATCH;
        }
        if (newClassTree.getClassBody() == null) {
            return Description.NO_MATCH;
        }
        if (!newClassTree.getArguments().isEmpty()) {
            return Description.NO_MATCH;
        }
        for (Tree tree : newClassTree.getClassBody().getMembers()) {
            switch (tree.getKind()) {
                case VARIABLE: {
                    VariableTree variableTree = (VariableTree)tree;
                    if (variableTree.getInitializer() == null) break;
                    return Description.NO_MATCH;
                }
                case BLOCK: {
                    return Description.NO_MATCH;
                }
            }
        }
        if (!UnusedAnonymousClass.sideEffectFreeConstructor(ASTHelpers.getType((Tree)newClassTree.getIdentifier()).tsym, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(newClassTree);
    }

    private static boolean sideEffectFreeConstructor(Symbol.TypeSymbol classType, VisitorState state) {
        if (classType.isInterface()) {
            return true;
        }
        for (String typeName : TYPES_WITH_SIDE_EFFECT_FREE_CONSTRUCTORS) {
            if (!ASTHelpers.isSameType(classType.type, state.getTypeFromString(typeName), state)) continue;
            return true;
        }
        return false;
    }
}

