/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;

@BugPattern(summary="In recent versions of Java, 'yield' is a contextual keyword, and calling an unqualified method with that name is an error.", severity=BugPattern.SeverityLevel.WARNING)
public class UnqualifiedYield
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree select = tree.getMethodSelect();
        if (!(select instanceof IdentifierTree)) {
            return Description.NO_MATCH;
        }
        if (!((IdentifierTree)select).getName().contentEquals("yield")) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String qualifier = UnqualifiedYield.getQualifier(state, ASTHelpers.getSymbol(tree), fix);
        return this.describeMatch(tree, (Fix)fix.prefixWith(select, qualifier + ".").build());
    }

    private static String getQualifier(VisitorState state, Symbol.MethodSymbol sym, SuggestedFix.Builder fix) {
        Symbol.ClassSymbol enclosingClass;
        if (sym.isStatic()) {
            return SuggestedFixes.qualifyType(state, fix, sym.owner.enclClass());
        }
        TreePath path = ASTHelpers.findPathFromEnclosingNodeToTopLevel(state.getPath(), ClassTree.class);
        if (sym.isMemberOf(ASTHelpers.getSymbol((ClassTree)path.getLeaf()), state.getTypes())) {
            return "this";
        }
        while (!sym.isMemberOf(enclosingClass = ASTHelpers.getSymbol((ClassTree)(path = ASTHelpers.findPathFromEnclosingNodeToTopLevel(path, ClassTree.class)).getLeaf()), state.getTypes())) {
        }
        return SuggestedFixes.qualifyType(state, fix, enclosingClass) + ".this";
    }
}

