/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.util.Name;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="It is unnecessary for this variable to be boxed. Use the primitive instead.", explanation="This variable is of boxed type, but equivalent semantics can be achieved using the corresponding primitive type, which avoids the cost of constructing an unnecessary object.", severity=BugPattern.SeverityLevel.SUGGESTION)
public class UnnecessaryBoxedVariable
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<ExpressionTree> VALUE_OF_MATCHER = MethodMatchers.staticMethod().onClass(UnnecessaryBoxedVariable::isBoxableType).named("valueOf");

    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        final FindBoxedUsagesScanner usages = new FindBoxedUsagesScanner(state);
        usages.scan((Tree)tree, null);
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(state){

            @Override
            public Void visitVariable(VariableTree tree, Void unused) {
                VisitorState innerState = this.state.withPath(this.getCurrentPath());
                UnnecessaryBoxedVariable.unboxed(tree, innerState).flatMap(u -> UnnecessaryBoxedVariable.this.handleVariable((Type)u, usages, tree, innerState)).ifPresent(this.state::reportMatch);
                return (Void)super.visitVariable(tree, null);
            }
        }.scan((Tree)tree, null);
        return Description.NO_MATCH;
    }

    private Optional<Description> handleVariable(Type unboxed, FindBoxedUsagesScanner usages, VariableTree tree, VisitorState state) {
        Symbol.VarSymbol varSymbol = ASTHelpers.getSymbol(tree);
        switch (varSymbol.getKind()) {
            case PARAMETER: {
                if (!UnnecessaryBoxedVariable.canChangeMethodSignature(state, (Symbol.MethodSymbol)varSymbol.getEnclosingElement()) || state.getPath().getParentPath().getLeaf() instanceof LambdaExpressionTree) {
                    return Optional.empty();
                }
            }
            case LOCAL_VARIABLE: {
                if (UnnecessaryBoxedVariable.variableMatches(tree, state)) break;
                return Optional.empty();
            }
            default: {
                return Optional.empty();
            }
        }
        return this.fixVariable(unboxed, usages, tree, state);
    }

    private Optional<Description> fixVariable(Type unboxed, FindBoxedUsagesScanner usages, VariableTree tree, VisitorState state) {
        Symbol.VarSymbol varSymbol = ASTHelpers.getSymbol(tree);
        if (usages.boxedUsageFound.contains(varSymbol)) {
            return Optional.empty();
        }
        if (!usages.dereferenced.contains(varSymbol) && varSymbol.getKind() == ElementKind.PARAMETER) {
            return Optional.empty();
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        fixBuilder.replace(tree.getType(), ((Name)unboxed.tsym.getSimpleName()).toString());
        UnnecessaryBoxedVariable.fixMethodInvocations((List<MethodInvocationTree>)usages.fixableSimpleMethodInvocations.get((Object)varSymbol), fixBuilder, state);
        UnnecessaryBoxedVariable.fixNullCheckInvocations((List<TreePath>)usages.fixableNullCheckInvocations.get((Object)varSymbol), fixBuilder, state);
        UnnecessaryBoxedVariable.fixCastingInvocations((List<TreePath>)usages.fixableCastMethodInvocations.get((Object)varSymbol), fixBuilder, state);
        AnnotationTree nullableAnnotation = ASTHelpers.getAnnotationWithSimpleName(tree.getModifiers().getAnnotations(), "Nullable");
        if (nullableAnnotation == null) {
            return Optional.of(this.describeMatch(tree, (Fix)fixBuilder.build()));
        }
        fixBuilder.replace(nullableAnnotation, "");
        return Optional.of(this.buildDescription(tree).setMessage("All usages of this @Nullable variable would result in a NullPointerException when it actually is null. Use the primitive type if this variable should never be null, or else fix the code to avoid unboxing or invoking its instance methods.").addFix(fixBuilder.build()).build());
    }

    private static Optional<Type> unboxed(Tree tree, VisitorState state) {
        Type type = ASTHelpers.getType(tree);
        if (type == null || !type.isReference()) {
            return Optional.empty();
        }
        Type unboxed = state.getTypes().unboxedType(type);
        if (unboxed == null || unboxed.getTag() == TypeTag.NONE || unboxed.getTag() == TypeTag.VOID) {
            return Optional.empty();
        }
        return Optional.of(unboxed);
    }

    private static void fixNullCheckInvocations(List<TreePath> nullCheckInvocations, SuggestedFix.Builder fixBuilder, VisitorState state) {
        for (TreePath pathForTree : nullCheckInvocations) {
            Preconditions.checkArgument(pathForTree.getLeaf() instanceof MethodInvocationTree);
            MethodInvocationTree methodInvocation = (MethodInvocationTree)pathForTree.getLeaf();
            ASTHelpers.TargetType targetType = ASTHelpers.targetType(state.withPath(pathForTree));
            if (targetType == null) {
                StatementTree statementTree = ASTHelpers.findEnclosingNode(pathForTree, StatementTree.class);
                if (statementTree == null) continue;
                fixBuilder.delete(statementTree);
                continue;
            }
            fixBuilder.replace(methodInvocation, state.getSourceForNode(methodInvocation.getArguments().get(0)));
        }
    }

    private static void fixMethodInvocations(List<MethodInvocationTree> simpleMethodInvocations, SuggestedFix.Builder fixBuilder, VisitorState state) {
        for (MethodInvocationTree methodInvocation : simpleMethodInvocations) {
            ExpressionTree receiver = ASTHelpers.getReceiver(methodInvocation);
            Type receiverType = ASTHelpers.getType(receiver);
            MemberSelectTree methodSelect = (MemberSelectTree)methodInvocation.getMethodSelect();
            fixBuilder.replace(methodInvocation, String.format("%s.%s(%s)", receiverType.tsym.getSimpleName(), methodSelect.getIdentifier(), state.getSourceForNode(receiver)));
        }
    }

    private static void fixCastingInvocations(List<TreePath> castMethodInvocations, SuggestedFix.Builder fixBuilder, VisitorState state) {
        for (TreePath castPath : castMethodInvocations) {
            MethodInvocationTree castInvocation = (MethodInvocationTree)castPath.getLeaf();
            ExpressionTree receiver = ASTHelpers.getReceiver(castInvocation);
            Type expressionType = ASTHelpers.getType(castInvocation);
            if (castPath.getParentPath() != null && castPath.getParentPath().getLeaf().getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
                fixBuilder.delete(castPath.getParentPath().getLeaf());
                continue;
            }
            Type unboxedReceiverType = state.getTypes().unboxedType(ASTHelpers.getType(receiver));
            if (unboxedReceiverType.getTag() == expressionType.getTag()) {
                fixBuilder.replace(castInvocation, state.getSourceForNode(receiver));
                continue;
            }
            fixBuilder.replace(castInvocation, String.format("(%s) %s", expressionType.tsym.getSimpleName(), state.getSourceForNode(receiver)));
        }
    }

    private static boolean variableMatches(VariableTree tree, VisitorState state) {
        ExpressionTree expression = tree.getInitializer();
        if (expression == null) {
            Tree leaf = state.getPath().getParentPath().getLeaf();
            if (!(leaf instanceof EnhancedForLoopTree)) {
                return true;
            }
            EnhancedForLoopTree node = (EnhancedForLoopTree)leaf;
            Type expressionType = ASTHelpers.getType(node.getExpression());
            if (expressionType == null) {
                return false;
            }
            Type elemtype = state.getTypes().elemtype(expressionType);
            return elemtype != null && elemtype.isPrimitive();
        }
        Type initializerType = ASTHelpers.getType(expression);
        if (initializerType == null) {
            return false;
        }
        if (initializerType.isPrimitive()) {
            return true;
        }
        return VALUE_OF_MATCHER.matches(expression, state);
    }

    private static boolean isBoxableType(Type type, VisitorState state) {
        Type unboxedType = state.getTypes().unboxedType(type);
        return unboxedType != null && unboxedType.getTag() != TypeTag.NONE;
    }

    private static boolean canChangeMethodSignature(VisitorState state, Symbol.MethodSymbol methodSymbol) {
        return !ASTHelpers.methodCanBeOverridden(methodSymbol) && ASTHelpers.findSuperMethods(methodSymbol, state.getTypes()).isEmpty();
    }

    private static boolean isBoxed(Symbol symbol, VisitorState state) {
        return symbol instanceof Symbol.VarSymbol && !state.getTypes().isSameType(state.getTypes().unboxedType(symbol.type), Type.noType);
    }

    private static class FindBoxedUsagesScanner
    extends TreePathScanner<Void, Void> {
        private static final Matcher<ExpressionTree> SIMPLE_METHOD_MATCH = MethodMatchers.instanceMethod().anyClass().namedAnyOf("hashCode", "toString");
        private static final Matcher<ExpressionTree> CAST_METHOD_MATCH = MethodMatchers.instanceMethod().onClass((x$0, x$1) -> UnnecessaryBoxedVariable.isBoxableType(x$0, x$1)).namedAnyOf("byteValue", "shortValue", "intValue", "longValue", "floatValue", "doubleValue", "booleanValue");
        private static final Matcher<ExpressionTree> NULL_CHECK_MATCH = Matchers.anyOf(MethodMatchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkNotNull"), MethodMatchers.staticMethod().onClass("com.google.common.base.Verify").named("verifyNonNull"), MethodMatchers.staticMethod().onClass("java.util.Objects").named("requireNonNull"));
        private final VisitorState state;
        private final ListMultimap<Symbol.VarSymbol, MethodInvocationTree> fixableSimpleMethodInvocations = ArrayListMultimap.create();
        private final ListMultimap<Symbol.VarSymbol, TreePath> fixableNullCheckInvocations = ArrayListMultimap.create();
        private final ListMultimap<Symbol.VarSymbol, TreePath> fixableCastMethodInvocations = ArrayListMultimap.create();
        private final Set<Symbol.VarSymbol> boxedUsageFound = new HashSet<Symbol.VarSymbol>();
        private final Set<Symbol.VarSymbol> dereferenced = new HashSet<Symbol.VarSymbol>();

        FindBoxedUsagesScanner(VisitorState state) {
            this.state = state;
        }

        @Override
        public Void scan(Tree tree, Void unused) {
            Symbol symbol = ASTHelpers.getSymbol(tree);
            if (this.boxedUsageFound.contains(symbol)) {
                return null;
            }
            return (Void)super.scan(tree, unused);
        }

        @Override
        public Void visitAssignment(AssignmentTree node, Void unused) {
            Symbol nodeSymbol = ASTHelpers.getSymbol(node.getVariable());
            if (!UnnecessaryBoxedVariable.isBoxed(nodeSymbol, this.state)) {
                return (Void)super.visitAssignment(node, unused);
            }
            if (!this.checkAssignmentExpression(node.getExpression())) {
                return this.scan((Tree)node.getExpression(), unused);
            }
            this.boxedUsageFound.add((Symbol.VarSymbol)nodeSymbol);
            return null;
        }

        private boolean checkAssignmentExpression(ExpressionTree expression) {
            Type expressionType = ASTHelpers.getType(expression);
            if (expressionType.isPrimitive()) {
                return false;
            }
            return !VALUE_OF_MATCHER.matches(expression, this.state.withPath(this.getCurrentPath())) && expression.getKind() != Tree.Kind.NEW_CLASS;
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, Void unused) {
            Symbol nodeSymbol = ASTHelpers.getSymbol(node);
            if (UnnecessaryBoxedVariable.isBoxed(nodeSymbol, this.state)) {
                this.dereferenced.add((Symbol.VarSymbol)nodeSymbol);
                VisitorState identifierState = this.state.withPath(this.getCurrentPath());
                ASTHelpers.TargetType targetType = ASTHelpers.targetType(identifierState);
                if (targetType != null && !targetType.type().isPrimitive()) {
                    this.boxedUsageFound.add((Symbol.VarSymbol)nodeSymbol);
                    return null;
                }
            }
            return (Void)super.visitIdentifier(node, unused);
        }

        @Override
        public Void visitCompoundAssignment(CompoundAssignmentTree node, Void unused) {
            return this.scan((Tree)node.getExpression(), unused);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
            Symbol firstArgSymbol;
            if (NULL_CHECK_MATCH.matches(node, this.state) && UnnecessaryBoxedVariable.isBoxed(firstArgSymbol = ASTHelpers.getSymbol(ASTHelpers.stripParentheses(node.getArguments().get(0))), this.state)) {
                this.dereferenced.add((Symbol.VarSymbol)firstArgSymbol);
                this.fixableNullCheckInvocations.put((Symbol.VarSymbol)firstArgSymbol, this.getCurrentPath());
                return null;
            }
            ExpressionTree receiver = ASTHelpers.getReceiver(node);
            Symbol receiverSymbol = ASTHelpers.getSymbol(receiver);
            if (receiver != null && UnnecessaryBoxedVariable.isBoxed(receiverSymbol, this.state)) {
                if (SIMPLE_METHOD_MATCH.matches(node, this.state)) {
                    this.fixableSimpleMethodInvocations.put((Symbol.VarSymbol)receiverSymbol, node);
                    return null;
                }
                if (CAST_METHOD_MATCH.matches(node, this.state)) {
                    this.fixableCastMethodInvocations.put((Symbol.VarSymbol)receiverSymbol, this.getCurrentPath());
                    return null;
                }
                this.boxedUsageFound.add((Symbol.VarSymbol)receiverSymbol);
                return null;
            }
            return (Void)super.visitMethodInvocation(node, unused);
        }

        @Override
        public Void visitReturn(ReturnTree node, Void unused) {
            Type returnType;
            MethodTree enclosingMethod;
            Symbol nodeSymbol = ASTHelpers.getSymbol(ASTHelpers.stripParentheses(node.getExpression()));
            if (!UnnecessaryBoxedVariable.isBoxed(nodeSymbol, this.state)) {
                return (Void)super.visitReturn(node, unused);
            }
            this.dereferenced.add((Symbol.VarSymbol)nodeSymbol);
            if (nodeSymbol.getKind() == ElementKind.PARAMETER && (enclosingMethod = ASTHelpers.findEnclosingMethod(this.state.withPath(this.getCurrentPath()))) != null && !(returnType = ASTHelpers.getType(enclosingMethod.getReturnType())).isPrimitive()) {
                this.boxedUsageFound.add((Symbol.VarSymbol)nodeSymbol);
            }
            return null;
        }

        @Override
        public Void visitMemberReference(MemberReferenceTree node, Void unused) {
            Symbol symbol;
            ExpressionTree qualifierExpression = node.getQualifierExpression();
            if (qualifierExpression.getKind() == Tree.Kind.IDENTIFIER && UnnecessaryBoxedVariable.isBoxed(symbol = ASTHelpers.getSymbol(qualifierExpression), this.state)) {
                this.boxedUsageFound.add((Symbol.VarSymbol)symbol);
                this.dereferenced.add((Symbol.VarSymbol)symbol);
                return null;
            }
            return (Void)super.visitMemberReference(node, unused);
        }
    }
}

