/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;

@BugPattern(summary="This expression can be implicitly boxed.", explanation="It is unnecessary for this assignment or return expression to be boxed explicitly.", severity=BugPattern.SeverityLevel.SUGGESTION)
public class UnnecessaryBoxedAssignment
extends BugChecker
implements BugChecker.AssignmentTreeMatcher,
BugChecker.ReturnTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final Matcher<ExpressionTree> VALUE_OF_MATCHER = MethodMatchers.staticMethod().onClass(UnnecessaryBoxedAssignment::isBoxableType).named("valueOf");

    @Override
    public Description matchReturn(ReturnTree tree, VisitorState state) {
        return this.matchCommon(tree.getExpression(), state);
    }

    @Override
    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        return this.matchCommon(tree.getExpression(), state);
    }

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        return this.matchCommon(tree.getInitializer(), state);
    }

    private Description matchCommon(ExpressionTree expression, VisitorState state) {
        if (expression == null || !VALUE_OF_MATCHER.matches(expression, state)) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)expression;
        if (methodInvocationTree.getArguments().size() != 1) {
            return Description.NO_MATCH;
        }
        ExpressionTree arg = methodInvocationTree.getArguments().get(0);
        Type argType = ASTHelpers.getType(arg);
        if (ASTHelpers.isSameType(argType, state.getSymtab().stringType, state)) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isSameType(state.getTypes().unboxedTypeOrType(argType), state.getTypes().unboxedType(ASTHelpers.getType(expression)), state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(expression, (Fix)SuggestedFix.replace(expression, state.getSourceForNode(arg)));
    }

    private static boolean isBoxableType(Type type, VisitorState state) {
        Type unboxedType = state.getTypes().unboxedType(type);
        return unboxedType != null && unboxedType.getTag() != TypeTag.NONE;
    }
}

