/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BadImport;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.lang.model.element.Name;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="This fully qualified name is unambiguous to the compiler if imported.")
public final class UnnecessarilyFullyQualified
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final ImmutableSet<String> EXEMPTED_NAMES = ImmutableSet.of("Annotation");

    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        if (tree.getTypeDecls().stream().anyMatch(t2 -> ASTHelpers.getSymbol(tree) != null && !ASTHelpers.getGeneratedBy(ASTHelpers.getSymbol(tree), state).isEmpty())) {
            return Description.NO_MATCH;
        }
        if (UnnecessarilyFullyQualified.isPackageInfo(tree)) {
            return Description.NO_MATCH;
        }
        final HashBasedTable table = HashBasedTable.create();
        final HashMultimap identifiersSeen = HashMultimap.create();
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(state){

            @Override
            public Void visitImport(ImportTree importTree, Void unused) {
                return null;
            }

            @Override
            public Void visitClass(ClassTree tree, Void unused) {
                this.scan((Tree)tree.getModifiers(), null);
                this.scan(tree.getTypeParameters(), null);
                if (!ASTHelpers.getSymbol(tree).isAnonymous()) {
                    this.scan(tree.getExtendsClause(), null);
                    this.scan(tree.getImplementsClause(), null);
                }
                this.scan(tree.getMembers(), null);
                return null;
            }

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                return ASTHelpers.isGeneratedConstructor(tree) ? null : (Void)super.visitMethod(tree, null);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
                if (!this.shouldIgnore()) {
                    this.handle(this.getCurrentPath());
                }
                return (Void)super.visitMemberSelect(memberSelectTree, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree identifierTree, Void unused) {
                Type type = ASTHelpers.getType(identifierTree);
                if (type != null) {
                    identifiersSeen.put(identifierTree.getName(), type.tsym);
                }
                return null;
            }

            private boolean shouldIgnore() {
                Tree parentTree = this.getCurrentPath().getParentPath().getLeaf();
                return parentTree instanceof MemberSelectTree && ASTHelpers.getSymbol(parentTree) instanceof Symbol.ClassSymbol;
            }

            private void handle(TreePath path) {
                MemberSelectTree tree = (MemberSelectTree)path.getLeaf();
                if (!this.isFullyQualified(tree)) {
                    return;
                }
                if (BadImport.BAD_NESTED_CLASSES.contains(tree.getIdentifier().toString())) {
                    if (tree.getExpression() instanceof MemberSelectTree && ASTHelpers.getSymbol(tree.getExpression()) instanceof Symbol.ClassSymbol) {
                        this.handle(new TreePath(path, tree.getExpression()));
                    }
                    return;
                }
                Symbol symbol = ASTHelpers.getSymbol(tree);
                if (!(symbol instanceof Symbol.ClassSymbol)) {
                    return;
                }
                if (this.state.getEndPosition(tree) == -1) {
                    return;
                }
                ArrayList<TreePath> treePaths = (ArrayList<TreePath>)table.get(tree.getIdentifier(), symbol.type.tsym);
                if (treePaths == null) {
                    treePaths = new ArrayList<TreePath>();
                    table.put(tree.getIdentifier(), symbol.type.tsym, treePaths);
                }
                treePaths.add(path);
            }

            private boolean isFullyQualified(MemberSelectTree tree) {
                final AtomicBoolean isFullyQualified = new AtomicBoolean();
                new SimpleTreeVisitor<Void, Void>(){

                    @Override
                    public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
                        return (Void)this.visit(memberSelectTree.getExpression(), null);
                    }

                    @Override
                    public Void visitIdentifier(IdentifierTree identifierTree, Void aVoid) {
                        if (ASTHelpers.getSymbol(identifierTree) instanceof Symbol.PackageSymbol) {
                            isFullyQualified.set(true);
                        }
                        return null;
                    }
                }.visit(tree, null);
                return isFullyQualified.get();
            }
        }.scan(state.getPath(), null);
        for (Map.Entry rows : table.rowMap().entrySet()) {
            List pathsToFix;
            Set meaningAtUsageSites;
            String nameString;
            Name name = (Name)rows.getKey();
            Map types = rows.getValue();
            if (types.size() > 1) continue;
            Symbol.TypeSymbol type = (Symbol.TypeSymbol)Iterables.getOnlyElement(types.keySet());
            if (Ascii.isLowerCase(name.charAt(0)) || identifiersSeen.get(name).stream().anyMatch(s2 -> !s2.equals(type)) || EXEMPTED_NAMES.contains(nameString = name.toString()) || (meaningAtUsageSites = (Set)(pathsToFix = (List)Iterables.getOnlyElement(types.values())).stream().map(path -> FindIdentifiers.findIdent(nameString, state.withPath((TreePath)path), Kinds.KindSelector.VAL_TYP)).collect(Collectors.toCollection(HashSet::new))).stream().anyMatch(s2 -> s2 != null && !s2.equals(type))) continue;
            SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
            if (meaningAtUsageSites.stream().anyMatch(Objects::isNull)) {
                fixBuilder.addImport(((Symbol.TypeSymbol)Iterables.getOnlyElement(types.keySet())).getQualifiedName().toString());
            }
            for (TreePath path2 : pathsToFix) {
                fixBuilder.replace(path2.getLeaf(), nameString);
            }
            SuggestedFix fix = fixBuilder.build();
            for (TreePath path3 : pathsToFix) {
                state.reportMatch(this.describeMatch(path3.getLeaf(), (Fix)fix));
            }
        }
        return Description.NO_MATCH;
    }

    private static boolean isPackageInfo(CompilationUnitTree tree) {
        String name = ASTHelpers.getFileName(tree);
        int idx = name.lastIndexOf(47);
        if (idx != -1) {
            name = name.substring(idx + 1);
        }
        return name.equals("package-info.java");
    }
}

