/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;

@BugPattern(summary="Unchecked exceptions do not need to be declared in the method signature.", severity=BugPattern.SeverityLevel.SUGGESTION)
public class ThrowsUncheckedException
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (tree.getThrows().isEmpty()) {
            return Description.NO_MATCH;
        }
        ArrayList<ExpressionTree> uncheckedExceptions = new ArrayList<ExpressionTree>();
        for (ExpressionTree expressionTree : tree.getThrows()) {
            Type exceptionType = ASTHelpers.getType(expressionTree);
            if (!ASTHelpers.isSubtype(exceptionType, state.getSymtab().runtimeExceptionType, state) && !ASTHelpers.isSubtype(exceptionType, state.getSymtab().errorType, state)) continue;
            uncheckedExceptions.add(expressionTree);
        }
        if (uncheckedExceptions.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch((Tree)uncheckedExceptions.get(0), SuggestedFixes.deleteExceptions(tree, state, uncheckedExceptions));
    }
}

