/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;

@BugPattern(summary="ThreadLocals should be stored in static fields", severity=BugPattern.SeverityLevel.WARNING)
public class ThreadLocalUsage
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final Matcher<ExpressionTree> NEW_THREAD_LOCAL = MethodMatchers.constructor().forClass(TypePredicates.isDescendantOf("java.lang.ThreadLocal"));
    private static final ImmutableSet<String> WELL_KNOWN_TYPES = ImmutableSet.of("java.lang.String", "java.lang.Boolean", "java.lang.Long", "java.lang.Integer", "java.lang.Short", "java.lang.Character", new String[]{"java.lang.Float", "java.lang.Double"});
    private static final Supplier<Symbol> JAVA_LANG_THREADLOCAL = VisitorState.memoize(state -> state.getSymbolFromString("java.lang.ThreadLocal"));
    private static final Supplier<Type> COM_GOOGLE_INJECT_SCOPE = VisitorState.memoize(state -> state.getTypeFromString("com.google.inject.Scope"));
    private static final Supplier<Type> JAVA_TEXT_DATEFORMAT = VisitorState.memoize(state -> state.getTypeFromString("java.text.DateFormat"));

    @Override
    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!NEW_THREAD_LOCAL.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        if (ThreadLocalUsage.wellKnownTypeArgument(tree, state)) {
            return Description.NO_MATCH;
        }
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (!(parent instanceof VariableTree)) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)parent);
        if (sym.isStatic()) {
            return Description.NO_MATCH;
        }
        if (Streams.stream(state.getPath()).filter(ClassTree.class::isInstance).map(ClassTree.class::cast).anyMatch(c -> {
            if (ASTHelpers.hasDirectAnnotationWithSimpleName(ASTHelpers.getSymbol(c), "Singleton")) {
                return true;
            }
            Type scopeType = COM_GOOGLE_INJECT_SCOPE.get(state);
            return ASTHelpers.isSubtype(ASTHelpers.getType(c), scopeType, state);
        })) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }

    private static boolean wellKnownTypeArgument(NewClassTree tree, VisitorState state) {
        Type type = ASTHelpers.getType(tree);
        if (type == null) {
            return false;
        }
        type = state.getTypes().asSuper(type, JAVA_LANG_THREADLOCAL.get(state));
        if (type == null) {
            return false;
        }
        if (type.getTypeArguments().isEmpty()) {
            return false;
        }
        Type argType = Iterables.getOnlyElement(type.getTypeArguments());
        if (WELL_KNOWN_TYPES.contains(argType.asElement().getQualifiedName().toString())) {
            return true;
        }
        return ASTHelpers.isSubtype(argType, JAVA_TEXT_DATEFORMAT.get(state), state);
    }
}

