/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Type;
import java.util.concurrent.atomic.AtomicInteger;

@BugPattern(summary="Thread.join needs to be immediately surrounded by a loop until it succeeds. Consider using Uninterruptibles.joinUninterruptibly.", severity=BugPattern.SeverityLevel.WARNING)
public class ThreadJoinLoop
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCH_THREAD_JOIN = Matchers.instanceMethod().onDescendantOf("java.lang.Thread").named("join");
    private static final Supplier<Type> JAVA_LANG_THREAD = VisitorState.memoize(state -> state.getTypeFromString("java.lang.Thread"));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        TryTree tryTree;
        StatementTree statements;
        String threadString = methodInvocationTree.getMethodSelect() instanceof MemberSelectTree ? state.getSourceForNode(((MemberSelectTree)methodInvocationTree.getMethodSelect()).getExpression()) : "this";
        if (!methodInvocationTree.getArguments().isEmpty()) {
            return Description.NO_MATCH;
        }
        if (!MATCH_THREAD_JOIN.matches(methodInvocationTree, state)) {
            return Description.NO_MATCH;
        }
        TreePath tryTreePath = ASTHelpers.findPathFromEnclosingNodeToTopLevel(state.getPath(), TryTree.class);
        if (tryTreePath == null) {
            return Description.NO_MATCH;
        }
        WhileLoopTree pathToLoop = ASTHelpers.findEnclosingNode(tryTreePath, WhileLoopTree.class);
        boolean hasWhileLoopOneStatement = false;
        if (pathToLoop != null && (statements = pathToLoop.getStatement()) instanceof BlockTree && ((BlockTree)statements).getStatements().size() == 1) {
            hasWhileLoopOneStatement = true;
        }
        if (ThreadJoinLoop.hasOtherInvocationsOrAssignments(methodInvocationTree, tryTree = (TryTree)tryTreePath.getLeaf(), state)) {
            return Description.NO_MATCH;
        }
        if (tryTree.getFinallyBlock() != null) {
            return Description.NO_MATCH;
        }
        Type interruptedType = state.getSymtab().interruptedExceptionType;
        for (CatchTree catchTree : tryTree.getCatches()) {
            Type typeSym = ASTHelpers.getType(catchTree.getParameter().getType());
            if (!ASTHelpers.isCastable(typeSym, interruptedType, state) || !catchTree.getBlock().getStatements().stream().allMatch(s2 -> s2 instanceof EmptyStatementTree)) continue;
            SuggestedFix.Builder fix = SuggestedFix.builder();
            String uninterruptibles = SuggestedFixes.qualifyType(state, fix, "com.google.common.util.concurrent.Uninterruptibles");
            fix.replace(hasWhileLoopOneStatement ? pathToLoop : tryTree, String.format("%s.joinUninterruptibly(%s);", uninterruptibles, threadString));
            return this.describeMatch(methodInvocationTree, (Fix)fix.build());
        }
        return Description.NO_MATCH;
    }

    private static boolean hasOtherInvocationsOrAssignments(final MethodInvocationTree methodInvocationTree, TryTree tryTree, final VisitorState state) {
        final AtomicInteger count = new AtomicInteger(0);
        final Type threadType = JAVA_LANG_THREAD.get(state);
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                if (!tree.equals(methodInvocationTree)) {
                    count.incrementAndGet();
                }
                return (Void)super.visitMethodInvocation(tree, null);
            }

            @Override
            public Void visitAssignment(AssignmentTree tree, Void unused) {
                if (ASTHelpers.isSubtype(ASTHelpers.getType(tree.getVariable()), threadType, state)) {
                    count.incrementAndGet();
                }
                return (Void)super.visitAssignment(tree, null);
            }
        }.scan(tryTree.getBlock(), null);
        return count.get() > 0;
    }
}

