/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.util.Name;
import java.util.Set;
import java.util.stream.Stream;

@BugPattern(summary="This test has members annotated with @Theory, @DataPoint, or @DataPoints but is using the default JUnit4 runner.", severity=BugPattern.SeverityLevel.ERROR)
public final class TheoryButNoTheories
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String THEORIES = "org.junit.experimental.theories.Theories";
    private static final Supplier<ImmutableSet<Name>> TYPES = VisitorState.memoize(s2 -> Stream.of("org.junit.experimental.theories.Theory", "org.junit.experimental.theories.DataPoint", "org.junit.experimental.theories.DataPoints").map(s2::getName).collect(ImmutableSet.toImmutableSet()));
    private static final MultiMatcher<Tree, AnnotationTree> USING_THEORIES_RUNNER = Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.hasArgumentWithValue("value", JUnitMatchers.isJUnit4TestRunnerOfType(ImmutableSet.of("org.junit.experimental.theories.Theories"))));

    @Override
    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!JUnitMatchers.hasJUnit4TestRunner.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        if (USING_THEORIES_RUNNER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        if (tree.getMembers().stream().allMatch(m4 -> ASTHelpers.annotationsAmong(ASTHelpers.getSymbol(m4), (Set<? extends Name>)TYPES.get(state), state).isEmpty())) {
            return Description.NO_MATCH;
        }
        AnnotationTree annotation = ASTHelpers.getAnnotationWithSimpleName(tree.getModifiers().getAnnotations(), "RunWith");
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fix.replace(annotation, String.format("@RunWith(%s.class)", SuggestedFixes.qualifyType(state, fix, THEORIES)));
        return this.describeMatch(tree, (Fix)fix.build());
    }
}

