/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MethodVisibility;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.Optional;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Code that contains System.exit() is untestable.", severity=BugPattern.SeverityLevel.ERROR)
public class SystemExitOutsideMain
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> CALLS_TO_SYSTEM_EXIT = Matchers.staticMethod().onClass("java.lang.System").named("exit");
    private static final Matcher<MethodTree> MAIN_METHOD = Matchers.allOf(Matchers.methodHasArity(1), Matchers.methodHasVisibility(MethodVisibility.Visibility.PUBLIC), Matchers.hasModifier(Modifier.STATIC), Matchers.methodReturns(Suppliers.VOID_TYPE), Matchers.methodIsNamed("main"), Matchers.methodHasParameters(Matchers.isSameType(Suppliers.arrayOf(Suppliers.STRING_TYPE))));
    private static final Matcher<ExpressionTree> CALLS_TO_SYSTEM_EXIT_OUTSIDE_MAIN = Matchers.allOf(CALLS_TO_SYSTEM_EXIT, Matchers.not(Matchers.enclosingMethod(MAIN_METHOD)));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (CALLS_TO_SYSTEM_EXIT_OUTSIDE_MAIN.matches(tree, state)) {
            Optional<Tree> mainMethodInThisClass = ASTHelpers.findEnclosingNode(state.getPath(), ClassTree.class).getMembers().stream().filter(t2 -> t2 instanceof MethodTree).filter(t2 -> MAIN_METHOD.matches((MethodTree)t2, state)).findAny();
            return mainMethodInThisClass.isPresent() ? Description.NO_MATCH : this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

