/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.StronglyType;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;

@BugPattern(summary="This primitive byte array is only used to construct ByteStrings. It would be clearer to strongly type the field instead.", severity=BugPattern.SeverityLevel.WARNING)
public final class StronglyTypeByteString
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<ExpressionTree> BYTE_STRING_FACTORY = Matchers.anyOf(Matchers.staticMethod().onClass("com.google.protobuf.ByteString").namedAnyOf("copyFrom").withParametersOfType(ImmutableSet.of(Suppliers.arrayOf(Suppliers.BYTE_TYPE))));

    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        return StronglyType.forCheck(this).addType(state.arrayTypeForType(state.getSymtab().byteType)).setFactoryMatcher(BYTE_STRING_FACTORY).build().match(tree, state);
    }
}

