/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractMustBeClosedChecker;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@BugPattern(altNames={"FilesLinesLeak"}, summary="Streams that encapsulate a closeable resource should be closed using try-with-resources", severity=BugPattern.SeverityLevel.WARNING)
public class StreamResourceLeak
extends AbstractMustBeClosedChecker
implements BugChecker.MethodTreeMatcher {
    public static final Matcher<ExpressionTree> MATCHER = MethodMatchers.staticMethod().onClass("java.nio.file.Files").namedAnyOf("lines", "newDirectoryStream", "list", "walk", "find");

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        return this.scanEntireMethodFor(MATCHER, tree, state);
    }

    @Override
    protected Optional<AbstractMustBeClosedChecker.Change> fix(ExpressionTree tree, VisitorState state, AbstractMustBeClosedChecker.NameSuggester suggester) {
        return AbstractMustBeClosedChecker.Change.of(StreamResourceLeak.definiteFix(tree, state));
    }

    private static SuggestedFix definiteFix(ExpressionTree tree, VisitorState state) {
        TreePath parentPath = state.getPath().getParentPath();
        final Tree parent = parentPath.getLeaf();
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String streamType = SuggestedFixes.prettyType(state, fix, ASTHelpers.getReturnType(tree));
        if (parent instanceof MemberSelectTree) {
            StatementTree statement = (StatementTree)state.findEnclosing(StatementTree.class);
            if (statement instanceof VariableTree) {
                VariableTree var = (VariableTree)statement;
                int pos = ASTHelpers.getStartPosition(var);
                int initPos = ASTHelpers.getStartPosition(var.getInitializer());
                int eqPos = pos + state.getSourceForNode(var).substring(0, initPos - pos).lastIndexOf(61);
                fix.replace(eqPos, initPos, String.format(";\ntry (%s stream = %s) {\n%s =", streamType, state.getSourceForNode(tree), var.getName()));
            } else {
                fix.prefixWith(statement, String.format("try (%s stream = %s) {\n", streamType, state.getSourceForNode(tree)));
            }
            fix.replace(tree, "stream");
            fix.postfixWith(statement, "}");
            return fix.build();
        }
        if (parent instanceof VariableTree) {
            int idx;
            Tree grandParent = parentPath.getParentPath().getLeaf();
            if (!(grandParent instanceof BlockTree)) {
                return SuggestedFix.emptyFix();
            }
            List<? extends StatementTree> statements = ((BlockTree)grandParent).getStatements();
            int lastUse = idx = statements.indexOf(parent);
            for (int i = idx + 1; i < statements.size(); ++i) {
                final boolean[] found = new boolean[]{false};
                statements.get(i).accept(new TreeScanner<Void, Void>(){

                    @Override
                    public Void visitIdentifier(IdentifierTree tree, Void unused) {
                        if (Objects.equals(ASTHelpers.getSymbol(tree), ASTHelpers.getSymbol(parent))) {
                            found[0] = true;
                        }
                        return null;
                    }
                }, null);
                if (!found[0]) continue;
                lastUse = i;
            }
            fix.prefixWith(parent, "try (");
            fix.replace(state.getEndPosition(((VariableTree)parent).getInitializer()), state.getEndPosition(parent), ") {");
            fix.postfixWith(statements.get(lastUse), "}");
            return fix.build();
        }
        if (parent instanceof EnhancedForLoopTree) {
            fix.prefixWith(parent, String.format("try (%s stream = %s) {\n", streamType, state.getSourceForNode(tree)));
            fix.replace(tree, "stream");
            fix.postfixWith(parent, "}");
            return fix.build();
        }
        if (parent instanceof MethodInvocationTree) {
            Tree grandParent = parentPath.getParentPath().getLeaf();
            if (!(grandParent instanceof ExpressionStatementTree)) {
                return SuggestedFix.emptyFix();
            }
            fix.prefixWith(parent, String.format("try (%s stream = %s) {\n", streamType, state.getSourceForNode(tree)));
            fix.replace(tree, "stream");
            fix.postfixWith(grandParent, "}");
            return fix.build();
        }
        return SuggestedFix.emptyFix();
    }
}

