/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_StaticImports_StaticImportInfo;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import javax.annotation.Nullable;

public final class StaticImports {
    @Nullable
    public static StaticImportInfo tryCreate(ImportTree tree, VisitorState state) {
        if (!tree.isStatic()) {
            return null;
        }
        if (!(tree.getQualifiedIdentifier() instanceof JCTree.JCFieldAccess)) {
            return null;
        }
        JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)tree.getQualifiedIdentifier();
        Name identifier = access.getIdentifier();
        if (identifier.contentEquals("*")) {
            return null;
        }
        return StaticImports.tryCreate(access, state);
    }

    @Nullable
    public static StaticImportInfo tryCreate(MemberSelectTree access, VisitorState state) {
        Name identifier = (Name)access.getIdentifier();
        Symbol importedType = ASTHelpers.getSymbol(access.getExpression());
        if (importedType == null) {
            return null;
        }
        Types types = state.getTypes();
        Type canonicalType = types.erasure(importedType.asType());
        if (canonicalType == null) {
            return null;
        }
        Symbol sym = ASTHelpers.getSymbol(access.getExpression());
        if (!(sym instanceof Symbol.TypeSymbol)) {
            return null;
        }
        Symbol.TypeSymbol baseType = (Symbol.TypeSymbol)sym;
        Symbol.PackageSymbol pkgSym = ((JCTree.JCCompilationUnit)state.getPath().getCompilationUnit()).packge;
        ImmutableSet<Symbol> members = StaticImports.lookup(baseType, baseType, identifier, types, pkgSym);
        if (members.isEmpty()) {
            return null;
        }
        Type canonicalOwner = null;
        for (Symbol member : members) {
            Type owner = types.erasure(member.owner.type);
            if (canonicalOwner != null && !types.isSubtype(owner, canonicalOwner)) continue;
            canonicalOwner = owner;
        }
        if (canonicalOwner == null) {
            return null;
        }
        if (members.size() == 1 && Iterables.getOnlyElement(members) instanceof Symbol.ClassSymbol) {
            return StaticImportInfo.create(access.toString(), Iterables.getOnlyElement(members).toString());
        }
        return StaticImportInfo.create(access.getExpression().toString(), canonicalOwner.toString(), identifier.toString(), members);
    }

    private static ImmutableSet<Symbol> lookup(Symbol.TypeSymbol typeSym, Symbol.TypeSymbol start, Name identifier, Types types, Symbol.PackageSymbol pkg) {
        if (typeSym == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder members = ImmutableSet.builder();
        members.addAll(StaticImports.lookup(types.supertype((Type)typeSym.type).tsym, start, identifier, types, pkg));
        for (Type type : types.interfaces(typeSym.type)) {
            members.addAll(StaticImports.lookup(type.tsym, start, identifier, types, pkg));
        }
        block5: for (Symbol member : typeSym.members().getSymbolsByName(identifier)) {
            if (!ASTHelpers.isStatic(member)) continue;
            switch ((int)(member.flags() & 7L)) {
                case 2: {
                    continue block5;
                }
                case 0: 
                case 4: {
                    if (ASTHelpers.enclosingPackage(member) == pkg) break;
                    continue block5;
                }
            }
            if (!member.isMemberOf(start, types)) continue;
            members.add(member);
        }
        return members.build();
    }

    private StaticImports() {
    }

    @AutoValue
    public static abstract class StaticImportInfo {
        public abstract String importedName();

        public abstract String canonicalName();

        public abstract Optional<String> simpleName();

        public abstract ImmutableSet<Symbol> members();

        public boolean isCanonical() {
            return this.canonicalName().equals(this.importedName());
        }

        public String importStatement() {
            if (this.members().isEmpty()) {
                return String.format("import %s;", this.canonicalName());
            }
            return String.format("import static %s.%s;", this.canonicalName(), this.simpleName().get());
        }

        private static StaticImportInfo create(String importedName, String canonicalName) {
            return new AutoValue_StaticImports_StaticImportInfo(importedName, canonicalName, Optional.absent(), ImmutableSet.of());
        }

        private static StaticImportInfo create(String importedName, String canonicalName, String simpleName, Iterable<Symbol> members) {
            return new AutoValue_StaticImports_StaticImportInfo(importedName, canonicalName, Optional.of(simpleName), ImmutableSet.copyOf(members));
        }
    }
}

