/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_StatementSwitchToExpressionSwitch_AnalysisResult;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Reachability;
import com.google.errorprone.util.RuntimeVersion;
import com.google.errorprone.util.SourceVersion;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="This statement switch can be converted to an equivalent expression switch")
public final class StatementSwitchToExpressionSwitch
extends BugChecker
implements BugChecker.SwitchTreeMatcher {
    private static final ImmutableSet<Tree.Kind> KINDS_CONVERTIBLE_WITHOUT_BRACES = ImmutableSet.of(Tree.Kind.THROW, Tree.Kind.EXPRESSION_STATEMENT);
    private static final Pattern FALL_THROUGH_PATTERN = Pattern.compile("\\bfalls?.?through\\b", 2);
    private final boolean enableDirectConversion;

    @Inject
    public StatementSwitchToExpressionSwitch(ErrorProneFlags flags) {
        this.enableDirectConversion = flags.getBoolean("StatementSwitchToExpressionSwitch:EnableDirectConversion").orElse(false);
    }

    @Override
    public Description matchSwitch(SwitchTree switchTree, VisitorState state) {
        if (!SourceVersion.supportsSwitchExpressions(state.context)) {
            return Description.NO_MATCH;
        }
        AnalysisResult analysisResult = StatementSwitchToExpressionSwitch.analyzeSwitchTree(switchTree);
        if (this.enableDirectConversion && analysisResult.canConvertDirectlyToExpressionSwitch()) {
            return this.convertDirectlyToExpressionSwitch(switchTree, state, analysisResult);
        }
        return Description.NO_MATCH;
    }

    private static AnalysisResult analyzeSwitchTree(SwitchTree switchTree) {
        List<? extends CaseTree> cases = switchTree.getCases();
        boolean allCasesHaveDefiniteControlFlow = true;
        ArrayList<Boolean> groupedWithNextCase = new ArrayList<Boolean>(Collections.nCopies(cases.size(), false));
        for (int caseIndex = 0; caseIndex < cases.size(); ++caseIndex) {
            CaseTree caseTree = cases.get(caseIndex);
            boolean isDefaultCase = caseTree.getExpression() == null;
            boolean isLastCaseInSwitch = caseIndex == cases.size() - 1;
            List<? extends StatementTree> statements = caseTree.getStatements();
            CaseFallThru caseFallThru = CaseFallThru.MAYBE_FALLS_THRU;
            if (statements == null) {
                return AnalysisResult.of(false, ImmutableList.of());
            }
            if (statements.isEmpty()) {
                caseFallThru = CaseFallThru.DEFINITELY_DOES_FALL_THRU;
                groupedWithNextCase.set(caseIndex, caseIndex < cases.size() - 1);
            } else {
                groupedWithNextCase.set(caseIndex, false);
                if (StatementSwitchToExpressionSwitch.areStatementsConvertibleToExpressionSwitch(statements, isLastCaseInSwitch)) {
                    caseFallThru = CaseFallThru.DEFINITELY_DOES_NOT_FALL_THRU;
                }
            }
            if (isDefaultCase) {
                boolean fallsIntoDefaultCase;
                boolean bl = fallsIntoDefaultCase = caseIndex > 0 && (Boolean)groupedWithNextCase.get(caseIndex - 1) != false;
                if (isLastCaseInSwitch) {
                    allCasesHaveDefiniteControlFlow &= !fallsIntoDefaultCase;
                    continue;
                }
                allCasesHaveDefiniteControlFlow &= !fallsIntoDefaultCase && caseFallThru.equals((Object)CaseFallThru.DEFINITELY_DOES_NOT_FALL_THRU);
                continue;
            }
            allCasesHaveDefiniteControlFlow &= !caseFallThru.equals((Object)CaseFallThru.MAYBE_FALLS_THRU);
        }
        return AnalysisResult.of(allCasesHaveDefiniteControlFlow, ImmutableList.copyOf(groupedWithNextCase));
    }

    private static boolean areStatementsConvertibleToExpressionSwitch(List<? extends StatementTree> statements, boolean isLastCaseInSwitch) {
        if (isLastCaseInSwitch) {
            return true;
        }
        if (statements.isEmpty()) {
            return true;
        }
        return !Reachability.canCompleteNormally(Iterables.getLast(statements));
    }

    private Description convertDirectlyToExpressionSwitch(SwitchTree switchTree, VisitorState state, AnalysisResult analysisResult) {
        List<? extends CaseTree> cases = switchTree.getCases();
        StringBuilder replacementCodeBuilder = new StringBuilder();
        replacementCodeBuilder.append("switch ").append(state.getSourceForNode(switchTree.getExpression())).append(" {");
        StringBuilder groupedCaseCommentsAccumulator = null;
        boolean firstCaseInGroup = true;
        for (int caseIndex = 0; caseIndex < cases.size(); ++caseIndex) {
            CaseTree caseTree = cases.get(caseIndex);
            boolean isDefaultCase = caseTree.getExpression() == null;
            ImmutableList<StatementTree> filteredStatements = StatementSwitchToExpressionSwitch.filterOutRedundantBreak(caseTree);
            Object transformedBlockSource = StatementSwitchToExpressionSwitch.transformBlock(caseTree, state, cases, caseIndex, filteredStatements);
            if (firstCaseInGroup) {
                groupedCaseCommentsAccumulator = new StringBuilder();
                replacementCodeBuilder.append("\n  ");
                if (!isDefaultCase) {
                    replacementCodeBuilder.append("case ");
                }
            }
            replacementCodeBuilder.append(isDefaultCase ? "default" : StatementSwitchToExpressionSwitch.printCaseExpressions(caseTree, state));
            if (((Boolean)analysisResult.groupedWithNextCase().get(caseIndex)).booleanValue()) {
                firstCaseInGroup = false;
                replacementCodeBuilder.append(", ");
                if (((String)transformedBlockSource).trim().isEmpty()) continue;
                groupedCaseCommentsAccumulator.append(StatementSwitchToExpressionSwitch.removeFallThruLines((String)transformedBlockSource));
                continue;
            }
            transformedBlockSource = groupedCaseCommentsAccumulator + (String)transformedBlockSource;
            replacementCodeBuilder.append(" -> ");
            if (filteredStatements.isEmpty()) {
                String trimmedTransformedBlockSource = ((String)transformedBlockSource).trim();
                if (trimmedTransformedBlockSource.isEmpty() || trimmedTransformedBlockSource.equals("break;")) {
                    replacementCodeBuilder.append("{}");
                } else {
                    replacementCodeBuilder.append("{").append((String)transformedBlockSource).append("\n}");
                }
            } else {
                Optional<String> commentsBeforeRemovedBreak = StatementSwitchToExpressionSwitch.extractCommentsBeforeRemovedBreak(caseTree, state, filteredStatements);
                if (commentsBeforeRemovedBreak.isPresent()) {
                    transformedBlockSource = (String)transformedBlockSource + "\n" + commentsBeforeRemovedBreak.get();
                }
                if (StatementSwitchToExpressionSwitch.shouldTransformCaseWithoutBraces(filteredStatements, (String)transformedBlockSource, (StatementTree)filteredStatements.get(0), state)) {
                    replacementCodeBuilder.append((String)transformedBlockSource);
                } else {
                    replacementCodeBuilder.append("{").append((String)transformedBlockSource).append("\n}");
                }
            }
            firstCaseInGroup = true;
        }
        replacementCodeBuilder.append("\n}");
        SuggestedFix.Builder suggestedFixBuilder = SuggestedFix.builder().replace(switchTree, replacementCodeBuilder.toString());
        return this.describeMatch(switchTree, (Fix)suggestedFixBuilder.build());
    }

    private static Optional<String> extractCommentsBeforeRemovedBreak(CaseTree caseTree, VisitorState state, ImmutableList<StatementTree> filteredStatements) {
        String commentsAfterNewLastStatement;
        if (caseTree.getStatements().size() > filteredStatements.size() && !filteredStatements.isEmpty() && !(commentsAfterNewLastStatement = state.getSourceCode().subSequence(state.getEndPosition(Iterables.getLast(filteredStatements)), ASTHelpers.getStartPosition(caseTree.getStatements().get(caseTree.getStatements().size() - 1))).toString().trim()).isEmpty()) {
            return Optional.of(commentsAfterNewLastStatement);
        }
        return Optional.empty();
    }

    private static ImmutableList<StatementTree> filterOutRedundantBreak(CaseTree caseTree) {
        boolean caseEndsWithUnlabelledBreak = Streams.findLast(caseTree.getStatements().stream()).filter(statement -> statement.getKind().equals((Object)Tree.Kind.BREAK)).filter(breakTree -> ((BreakTree)breakTree).getLabel() == null).isPresent();
        return caseEndsWithUnlabelledBreak ? caseTree.getStatements().stream().limit(caseTree.getStatements().size() - 1).collect(ImmutableList.toImmutableList()) : ImmutableList.copyOf(caseTree.getStatements());
    }

    private static String transformBlock(CaseTree caseTree, VisitorState state, List<? extends CaseTree> cases, int caseIndex, ImmutableList<StatementTree> filteredStatements) {
        StringBuilder transformedBlockBuilder = new StringBuilder();
        int codeBlockStart = StatementSwitchToExpressionSwitch.extractLhsComments(caseTree, state, transformedBlockBuilder);
        int codeBlockEnd = filteredStatements.isEmpty() ? StatementSwitchToExpressionSwitch.getBlockEnd(state, caseTree, cases, caseIndex) : state.getEndPosition((Tree)Streams.findLast(filteredStatements.stream()).get());
        transformedBlockBuilder.append(state.getSourceCode(), codeBlockStart, codeBlockEnd);
        return transformedBlockBuilder.toString();
    }

    private static int extractLhsComments(CaseTree caseTree, VisitorState state, StringBuilder stringBuilder) {
        int lhsStart = ASTHelpers.getStartPosition(caseTree);
        int lhsEnd = caseTree.getStatements().isEmpty() ? state.getEndPosition(caseTree) : ASTHelpers.getStartPosition(caseTree.getStatements().get(0));
        state.getOffsetTokens(lhsStart, lhsEnd).stream().flatMap(errorProneToken -> errorProneToken.comments().stream()).forEach(comment -> stringBuilder.append(comment.getText()).append("\n"));
        return lhsEnd;
    }

    private static int getBlockEnd(VisitorState state, CaseTree caseTree, List<? extends CaseTree> cases, int caseIndex) {
        if (caseIndex == cases.size() - 1) {
            return state.getEndPosition(caseTree);
        }
        return ((JCTree)((Object)cases.get(caseIndex + 1))).getStartPosition();
    }

    private static boolean shouldTransformCaseWithoutBraces(ImmutableList<StatementTree> statementTrees, String transformedBlockSource, StatementTree firstStatement, VisitorState state) {
        if (statementTrees.isEmpty()) {
            return false;
        }
        if (statementTrees.size() > 1) {
            return false;
        }
        if (!transformedBlockSource.trim().equals(state.getSourceForNode(firstStatement).trim())) {
            return false;
        }
        StatementTree onlyStatementTree = (StatementTree)statementTrees.get(0);
        return KINDS_CONVERTIBLE_WITHOUT_BRACES.contains((Object)onlyStatementTree.getKind());
    }

    private static String removeFallThruLines(String comments) {
        String string;
        StringBuilder output = new StringBuilder();
        BufferedReader br = new BufferedReader(new CharArrayReader(comments.toCharArray()));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (FALL_THROUGH_PATTERN.matcher(line).find()) continue;
                output.append(line).append("\n");
            }
            string = output.length() > 0 ? output.substring(0, output.length() - 1) : "";
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return comments;
            }
        }
        br.close();
        return string;
    }

    private static String printCaseExpressions(CaseTree caseTree, VisitorState state) {
        return StatementSwitchToExpressionSwitch.getExpressions(caseTree).map(state::getSourceForNode).collect(Collectors.joining(", "));
    }

    private static Stream<? extends ExpressionTree> getExpressions(CaseTree caseTree) {
        try {
            if (RuntimeVersion.isAtLeast12()) {
                return ((List)CaseTree.class.getMethod("getExpressions", new Class[0]).invoke((Object)caseTree, new Object[0])).stream();
            }
            return Stream.of(caseTree.getExpression());
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    @AutoValue
    static abstract class AnalysisResult {
        AnalysisResult() {
        }

        abstract boolean canConvertDirectlyToExpressionSwitch();

        abstract ImmutableList<Boolean> groupedWithNextCase();

        static AnalysisResult of(boolean canConvertDirectlyToExpressionSwitch, ImmutableList<Boolean> groupedWithNextCase) {
            return new AutoValue_StatementSwitchToExpressionSwitch_AnalysisResult(canConvertDirectlyToExpressionSwitch, groupedWithNextCase);
        }
    }

    private static enum CaseFallThru {
        DEFINITELY_DOES_NOT_FALL_THRU,
        MAYBE_FALLS_THRU,
        DEFINITELY_DOES_FALL_THRU;

    }
}

