/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.ReplacementVariableFinder;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import javax.lang.model.element.Modifier;
import org.checkerframework.checker.nullness.qual.Nullable;

@BugPattern(summary="Variable assigned to itself", severity=BugPattern.SeverityLevel.ERROR)
public class SelfAssignment
extends BugChecker
implements BugChecker.AssignmentTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final Matcher<MethodInvocationTree> NON_NULL_MATCHER = Matchers.anyOf(Matchers.staticMethod().onClass("java.util.Objects").named("requireNonNull"), Matchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkNotNull"), Matchers.staticMethod().onClass("com.google.common.time.Durations").namedAnyOf("checkNotNegative", "checkPositive"), Matchers.staticMethod().onClass("com.google.protobuf.util.Durations").namedAnyOf("checkNotNegative", "checkPositive", "checkValid"), Matchers.staticMethod().onClass("com.google.protobuf.util.Timestamps").named("checkValid"));

    @Override
    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        if (!tree.getKind().equals((Object)Tree.Kind.ASSIGNMENT)) {
            return Description.NO_MATCH;
        }
        ExpressionTree expression = SelfAssignment.skipCast(SelfAssignment.stripNullCheck(tree.getExpression(), state));
        if (ASTHelpers.sameVariable(tree.getVariable(), expression)) {
            return this.describeForAssignment(tree, state);
        }
        return Description.NO_MATCH;
    }

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        ExpressionTree initializer = SelfAssignment.stripNullCheck(tree.getInitializer(), state);
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (initializer == null || initializer.getKind() != Tree.Kind.MEMBER_SELECT || parent.getKind() != Tree.Kind.CLASS || !tree.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
            return Description.NO_MATCH;
        }
        MemberSelectTree rhs = (MemberSelectTree)initializer;
        Symbol rhsClass = ASTHelpers.getSymbol(rhs.getExpression());
        Symbol lhsClass = ASTHelpers.getSymbol(parent);
        if (rhsClass != null && lhsClass != null && rhsClass.equals(lhsClass) && rhs.getIdentifier().contentEquals(tree.getName())) {
            return this.describeForVarDecl(tree, state);
        }
        return Description.NO_MATCH;
    }

    private static ExpressionTree skipCast(ExpressionTree expression) {
        return (ExpressionTree)new SimpleTreeVisitor<ExpressionTree, Void>(){

            @Override
            public ExpressionTree visitParenthesized(ParenthesizedTree node, Void unused) {
                return node.getExpression().accept(this, null);
            }

            @Override
            public ExpressionTree visitTypeCast(TypeCastTree node, Void unused) {
                return node.getExpression().accept(this, null);
            }

            @Override
            protected @Nullable ExpressionTree defaultAction(Tree node, Void unused) {
                return node instanceof ExpressionTree ? (ExpressionTree)node : null;
            }
        }.visit(expression, null);
    }

    private static ExpressionTree stripNullCheck(ExpressionTree expression, VisitorState state) {
        MethodInvocationTree methodInvocation;
        if (expression != null && expression.getKind() == Tree.Kind.METHOD_INVOCATION && NON_NULL_MATCHER.matches(methodInvocation = (MethodInvocationTree)expression, state)) {
            return methodInvocation.getArguments().get(0);
        }
        return expression;
    }

    public Description describeForVarDecl(VariableTree tree, VisitorState state) {
        Object varDeclStr = state.getSourceForNode(tree);
        int equalsIndex = ((String)varDeclStr).indexOf(61);
        if (equalsIndex < 0) {
            throw new IllegalStateException("Expected variable declaration to have an initializer: " + state.getSourceForNode(tree));
        }
        varDeclStr = ((String)varDeclStr).substring(0, equalsIndex - 1) + ";";
        return this.describeMatch(tree, (Fix)SuggestedFix.replace(tree, (String)varDeclStr));
    }

    public Description describeForAssignment(AssignmentTree assignmentTree, VisitorState state) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        SuggestedFix fix = SuggestedFix.delete(parent);
        ExpressionTree lhs = assignmentTree.getVariable();
        ExpressionTree rhs = assignmentTree.getExpression();
        if (assignmentTree.getExpression().getKind() == Tree.Kind.METHOD_INVOCATION) {
            fix = SuggestedFix.replace(assignmentTree, state.getSourceForNode(rhs));
            rhs = SelfAssignment.stripNullCheck(rhs, state);
        }
        rhs = SelfAssignment.skipCast(rhs);
        ImmutableList<Object> exploratoryFieldFixes = ImmutableList.of();
        if (lhs.getKind() == Tree.Kind.MEMBER_SELECT) {
            Preconditions.checkState(rhs.getKind() == Tree.Kind.IDENTIFIER || rhs.getKind() == Tree.Kind.MEMBER_SELECT);
            Type rhsType = ASTHelpers.getType(rhs);
            exploratoryFieldFixes = ReplacementVariableFinder.fixesByReplacingExpressionWithMethodParameter(rhs, varDecl -> ASTHelpers.isSameType(rhsType, varDecl.type, state), state);
        } else if (rhs.getKind() == Tree.Kind.IDENTIFIER) {
            Preconditions.checkState(lhs.getKind() == Tree.Kind.IDENTIFIER);
            Type lhsType = ASTHelpers.getType(lhs);
            exploratoryFieldFixes = ReplacementVariableFinder.fixesByReplacingExpressionWithLocallyDeclaredField(lhs, var -> !Flags.isStatic(var.sym) && (var.sym.flags() & 0x10L) == 0L && ASTHelpers.isSameType(lhsType, var.type, state), state);
        }
        if (exploratoryFieldFixes.isEmpty()) {
            return this.describeMatch(assignmentTree, (Fix)fix);
        }
        return this.buildDescription(assignmentTree).addAllFixes(exploratoryFieldFixes).build();
    }
}

