/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;

@BugPattern(summary="Returned Rx objects must be checked. Ignoring a returned Rx value means it is never scheduled for execution", explanation="Methods that return an ignored [Observable | Single | Flowable | Maybe ] generally indicate errors.\n\nIf you don\u2019t check the return value of these methods, the observables may never execute. It also means the error case is not being handled", severity=BugPattern.SeverityLevel.WARNING)
public final class RxReturnValueIgnored
extends AbstractReturnValueIgnored {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.allOf(Matchers.kindIs(Tree.Kind.METHOD_INVOCATION), Matchers.anyOf(Matchers.isSubtypeOf("io.reactivex.Observable"), Matchers.isSubtypeOf("io.reactivex.Flowable"), Matchers.isSubtypeOf("io.reactivex.Single"), Matchers.isSubtypeOf("io.reactivex.Maybe"), Matchers.isSubtypeOf("io.reactivex.Completable"), Matchers.isSubtypeOf("rx.Observable"), Matchers.isSubtypeOf("rx.Single"), Matchers.isSubtypeOf("rx.Completable")), Matchers.not(Matchers.anyOf(RxReturnValueIgnored::hasCirvAnnotation, RxReturnValueIgnored::isExemptedMethod)));
    private static final Supplier<Type> JAVA_UTIL_MAP = VisitorState.memoize(state -> state.getTypeFromString("java.util.Map"));

    private static boolean hasCirvAnnotation(ExpressionTree tree, VisitorState state) {
        Symbol untypedSymbol = ASTHelpers.getSymbol(tree);
        if (!(untypedSymbol instanceof Symbol.MethodSymbol)) {
            return false;
        }
        Symbol.MethodSymbol sym = (Symbol.MethodSymbol)untypedSymbol;
        if (ASTHelpers.hasAnnotation((Symbol)sym, CanIgnoreReturnValue.class, state)) {
            return true;
        }
        return ASTHelpers.streamSuperMethods(sym, state.getTypes()).anyMatch(superSym -> ASTHelpers.hasAnnotation((Symbol)superSym, CanIgnoreReturnValue.class, state) && superSym.getReturnType().tsym.equals(sym.getReturnType().tsym));
    }

    private static boolean isExemptedMethod(ExpressionTree tree, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol(tree);
        if (!(sym instanceof Symbol.MethodSymbol)) {
            return false;
        }
        return ASTHelpers.isSubtype(sym.owner.type, JAVA_UTIL_MAP.get(state), state) && sym.name.contentEquals("put");
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Description description = super.matchMethodInvocation(tree, state);
        return description.equals(Description.NO_MATCH) ? Description.NO_MATCH : this.describeMatch(tree);
    }

    @Override
    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        Description description = super.matchMemberReference(tree, state);
        return description.equals(Description.NO_MATCH) ? Description.NO_MATCH : this.describeMatch(tree);
    }

    @Override
    public Matcher<? super ExpressionTree> specializedMatcher() {
        return MATCHER;
    }
}

